/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsClient;
import software.amazon.awssdk.services.ssmincidents.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmincidents.model.FindingSummary;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentFindingsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentFindingsResponse;

public class ListIncidentFindingsIterable
implements SdkIterable<ListIncidentFindingsResponse> {
    private final SsmIncidentsClient client;
    private final ListIncidentFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIncidentFindingsIterable(SsmIncidentsClient client, ListIncidentFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIncidentFindingsResponseFetcher();
    }

    public Iterator<ListIncidentFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FindingSummary> findings() {
        Function<ListIncidentFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIncidentFindingsResponseFetcher
    implements SyncPageFetcher<ListIncidentFindingsResponse> {
        private ListIncidentFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListIncidentFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIncidentFindingsResponse nextPage(ListIncidentFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListIncidentFindingsIterable.this.client.listIncidentFindings(ListIncidentFindingsIterable.this.firstRequest);
            }
            return ListIncidentFindingsIterable.this.client.listIncidentFindings((ListIncidentFindingsRequest)((Object)ListIncidentFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

