/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcePolicy> {
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyDocument").getter(ResourcePolicy.getter(ResourcePolicy::policyDocument)).setter(ResourcePolicy.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyId").getter(ResourcePolicy.getter(ResourcePolicy::policyId)).setter(ResourcePolicy.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyId").build()}).build();
    private static final SdkField<String> RAM_RESOURCE_SHARE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ramResourceShareRegion").getter(ResourcePolicy.getter(ResourcePolicy::ramResourceShareRegion)).setter(ResourcePolicy.setter(Builder::ramResourceShareRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ramResourceShareRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_DOCUMENT_FIELD, POLICY_ID_FIELD, RAM_RESOURCE_SHARE_REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("policyDocument", POLICY_DOCUMENT_FIELD);
            this.put("policyId", POLICY_ID_FIELD);
            this.put("ramResourceShareRegion", RAM_RESOURCE_SHARE_REGION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String policyDocument;
    private final String policyId;
    private final String ramResourceShareRegion;

    private ResourcePolicy(BuilderImpl builder) {
        this.policyDocument = builder.policyDocument;
        this.policyId = builder.policyId;
        this.ramResourceShareRegion = builder.ramResourceShareRegion;
    }

    public final String policyDocument() {
        return this.policyDocument;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String ramResourceShareRegion() {
        return this.ramResourceShareRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramResourceShareRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePolicy)) {
            return false;
        }
        ResourcePolicy other = (ResourcePolicy)obj;
        return Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.ramResourceShareRegion(), other.ramResourceShareRegion());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcePolicy").add("PolicyDocument", (Object)this.policyDocument()).add("PolicyId", (Object)this.policyId()).add("RamResourceShareRegion", (Object)this.ramResourceShareRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "policyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "ramResourceShareRegion": {
                return Optional.ofNullable(clazz.cast(this.ramResourceShareRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourcePolicy, T> g) {
        return obj -> g.apply((ResourcePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyDocument;
        private String policyId;
        private String ramResourceShareRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePolicy model) {
            this.policyDocument(model.policyDocument);
            this.policyId(model.policyId);
            this.ramResourceShareRegion(model.ramResourceShareRegion);
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getRamResourceShareRegion() {
            return this.ramResourceShareRegion;
        }

        public final void setRamResourceShareRegion(String ramResourceShareRegion) {
            this.ramResourceShareRegion = ramResourceShareRegion;
        }

        @Override
        public final Builder ramResourceShareRegion(String ramResourceShareRegion) {
            this.ramResourceShareRegion = ramResourceShareRegion;
            return this;
        }

        public ResourcePolicy build() {
            return new ResourcePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcePolicy> {
        public Builder policyDocument(String var1);

        public Builder policyId(String var1);

        public Builder ramResourceShareRegion(String var1);
    }
}

