/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SsmTargetAccount {
    RESPONSE_PLAN_OWNER_ACCOUNT("RESPONSE_PLAN_OWNER_ACCOUNT"),
    IMPACTED_ACCOUNT("IMPACTED_ACCOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SsmTargetAccount> VALUE_MAP;
    private final String value;

    private SsmTargetAccount(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SsmTargetAccount fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SsmTargetAccount> knownValues() {
        EnumSet<SsmTargetAccount> knownValues = EnumSet.allOf(SsmTargetAccount.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SsmTargetAccount.class, SsmTargetAccount::toString);
    }
}

