/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRelatedItemsRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, ListRelatedItemsRequest> {
    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("incidentRecordArn").getter(ListRelatedItemsRequest.getter(ListRelatedItemsRequest::incidentRecordArn)).setter(ListRelatedItemsRequest.setter(Builder::incidentRecordArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRelatedItemsRequest.getter(ListRelatedItemsRequest::maxResults)).setter(ListRelatedItemsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRelatedItemsRequest.getter(ListRelatedItemsRequest::nextToken)).setter(ListRelatedItemsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCIDENT_RECORD_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String incidentRecordArn;
    private final Integer maxResults;
    private final String nextToken;

    private ListRelatedItemsRequest(BuilderImpl builder) {
        super(builder);
        this.incidentRecordArn = builder.incidentRecordArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String incidentRecordArn() {
        return this.incidentRecordArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentRecordArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRelatedItemsRequest)) {
            return false;
        }
        ListRelatedItemsRequest other = (ListRelatedItemsRequest)((Object)obj);
        return Objects.equals(this.incidentRecordArn(), other.incidentRecordArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRelatedItemsRequest").add("IncidentRecordArn", (Object)this.incidentRecordArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "incidentRecordArn": {
                return Optional.ofNullable(clazz.cast(this.incidentRecordArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRelatedItemsRequest, T> g) {
        return obj -> g.apply((ListRelatedItemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private String incidentRecordArn;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRelatedItemsRequest model) {
            super(model);
            this.incidentRecordArn(model.incidentRecordArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getIncidentRecordArn() {
            return this.incidentRecordArn;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRelatedItemsRequest build() {
            return new ListRelatedItemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRelatedItemsRequest> {
        public Builder incidentRecordArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

