/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.model.GetReplicationSetRequest;
import software.amazon.awssdk.services.ssmincidents.model.GetReplicationSetResponse;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.services.ssmincidents.waiters.SsmIncidentsAsyncWaiter;
import software.amazon.awssdk.services.ssmincidents.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultSsmIncidentsAsyncWaiter
implements SsmIncidentsAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final SsmIncidentsAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetReplicationSetResponse> waitForReplicationSetActiveWaiter;
    private final AsyncWaiter<GetReplicationSetResponse> waitForReplicationSetDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultSsmIncidentsAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (SsmIncidentsAsyncClient)SsmIncidentsAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.waitForReplicationSetActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetReplicationSetResponse.class).acceptors(DefaultSsmIncidentsAsyncWaiter.waitForReplicationSetActiveWaiterAcceptors())).overrideConfiguration(DefaultSsmIncidentsAsyncWaiter.waitForReplicationSetActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.waitForReplicationSetDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetReplicationSetResponse.class).acceptors(DefaultSsmIncidentsAsyncWaiter.waitForReplicationSetDeletedWaiterAcceptors())).overrideConfiguration(DefaultSsmIncidentsAsyncWaiter.waitForReplicationSetDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReplicationSetResponse>> waitUntilWaitForReplicationSetActive(GetReplicationSetRequest getReplicationSetRequest) {
        return this.waitForReplicationSetActiveWaiter.runAsync(() -> this.client.getReplicationSet(this.applyWaitersUserAgent(getReplicationSetRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReplicationSetResponse>> waitUntilWaitForReplicationSetActive(GetReplicationSetRequest getReplicationSetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.waitForReplicationSetActiveWaiter.runAsync(() -> this.client.getReplicationSet(this.applyWaitersUserAgent(getReplicationSetRequest)), DefaultSsmIncidentsAsyncWaiter.waitForReplicationSetActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReplicationSetResponse>> waitUntilWaitForReplicationSetDeleted(GetReplicationSetRequest getReplicationSetRequest) {
        return this.waitForReplicationSetDeletedWaiter.runAsync(() -> this.client.getReplicationSet(this.applyWaitersUserAgent(getReplicationSetRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReplicationSetResponse>> waitUntilWaitForReplicationSetDeleted(GetReplicationSetRequest getReplicationSetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.waitForReplicationSetDeletedWaiter.runAsync(() -> this.client.getReplicationSet(this.applyWaitersUserAgent(getReplicationSetRequest)), DefaultSsmIncidentsAsyncWaiter.waitForReplicationSetDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetReplicationSetResponse>> waitForReplicationSetActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReplicationSetResponse>> result = new ArrayList<WaiterAcceptor<? super GetReplicationSetResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReplicationSetResponse>> waitForReplicationSetDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReplicationSetResponse>> result = new ArrayList<WaiterAcceptor<? super GetReplicationSetResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultSsmIncidentsAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "DELETING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("replicationSet").field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration waitForReplicationSetActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration waitForReplicationSetDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static SsmIncidentsAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends SsmIncidentsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((SsmIncidentsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements SsmIncidentsAsyncWaiter.Builder {
        private SsmIncidentsAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public SsmIncidentsAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public SsmIncidentsAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public SsmIncidentsAsyncWaiter.Builder client(SsmIncidentsAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public SsmIncidentsAsyncWaiter build() {
            return new DefaultSsmIncidentsAsyncWaiter(this);
        }
    }
}

