/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDeletionProtectionRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<UpdateDeletionProtectionRequest.Builder, UpdateDeletionProtectionRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateDeletionProtectionRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateDeletionProtectionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DELETION_PROTECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletionProtected").getter(getter(UpdateDeletionProtectionRequest::deletionProtected))
            .setter(setter(Builder::deletionProtected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtected").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CLIENT_TOKEN_FIELD,
            DELETION_PROTECTED_FIELD));

    private final String arn;

    private final String clientToken;

    private final Boolean deletionProtected;

    private UpdateDeletionProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.deletionProtected = builder.deletionProtected;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication set to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication set to update.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A token that ensures that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token that ensures that the operation is called only once with the specified details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies if deletion protection is turned on or off in your account.
     * </p>
     * 
     * @return Specifies if deletion protection is turned on or off in your account.
     */
    public final Boolean deletionProtected() {
        return deletionProtected;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtected());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeletionProtectionRequest)) {
            return false;
        }
        UpdateDeletionProtectionRequest other = (UpdateDeletionProtectionRequest) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(deletionProtected(), other.deletionProtected());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDeletionProtectionRequest").add("Arn", arn()).add("ClientToken", clientToken())
                .add("DeletionProtected", deletionProtected()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "deletionProtected":
            return Optional.ofNullable(clazz.cast(deletionProtected()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeletionProtectionRequest, T> g) {
        return obj -> g.apply((UpdateDeletionProtectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDeletionProtectionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication set to update.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the replication set to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A token that ensures that the operation is called only once with the specified details.
         * </p>
         * 
         * @param clientToken
         *        A token that ensures that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies if deletion protection is turned on or off in your account.
         * </p>
         * 
         * @param deletionProtected
         *        Specifies if deletion protection is turned on or off in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtected(Boolean deletionProtected);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private String arn;

        private String clientToken;

        private Boolean deletionProtected;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeletionProtectionRequest model) {
            super(model);
            arn(model.arn);
            clientToken(model.clientToken);
            deletionProtected(model.deletionProtected);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDeletionProtected() {
            return deletionProtected;
        }

        public final void setDeletionProtected(Boolean deletionProtected) {
            this.deletionProtected = deletionProtected;
        }

        @Override
        public final Builder deletionProtected(Boolean deletionProtected) {
            this.deletionProtected = deletionProtected;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeletionProtectionRequest build() {
            return new UpdateDeletionProtectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
