/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of Amazon Web Services Region that your Incident Manager data will be replicated to and the KMS key used to
 * encrypt the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationSet implements SdkPojo, Serializable, ToCopyableBuilder<ReplicationSet.Builder, ReplicationSet> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ReplicationSet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(ReplicationSet::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdTime").getter(getter(ReplicationSet::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletionProtected").getter(getter(ReplicationSet::deletionProtected))
            .setter(setter(Builder::deletionProtected))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtected").build()).build();

    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastModifiedBy").getter(getter(ReplicationSet::lastModifiedBy)).setter(setter(Builder::lastModifiedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime").getter(getter(ReplicationSet::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()).build();

    private static final SdkField<Map<String, RegionInfo>> REGION_MAP_FIELD = SdkField
            .<Map<String, RegionInfo>> builder(MarshallingType.MAP)
            .memberName("regionMap")
            .getter(getter(ReplicationSet::regionMap))
            .setter(setter(Builder::regionMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<RegionInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ReplicationSet::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_BY_FIELD,
            CREATED_TIME_FIELD, DELETION_PROTECTED_FIELD, LAST_MODIFIED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, REGION_MAP_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String createdBy;

    private final Instant createdTime;

    private final Boolean deletionProtected;

    private final String lastModifiedBy;

    private final Instant lastModifiedTime;

    private final Map<String, RegionInfo> regionMap;

    private final String status;

    private ReplicationSet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
        this.deletionProtected = builder.deletionProtected;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.regionMap = builder.regionMap;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication set.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Details about who created the replication set.
     * </p>
     * 
     * @return Details about who created the replication set.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * When the replication set was created.
     * </p>
     * 
     * @return When the replication set was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * Determines if the replication set deletion protection is enabled or not. If deletion protection is enabled, you
     * can't delete the last Amazon Web Services Region in the replication set.
     * </p>
     * 
     * @return Determines if the replication set deletion protection is enabled or not. If deletion protection is
     *         enabled, you can't delete the last Amazon Web Services Region in the replication set.
     */
    public final Boolean deletionProtected() {
        return deletionProtected;
    }

    /**
     * <p>
     * Who last modified the replication set.
     * </p>
     * 
     * @return Who last modified the replication set.
     */
    public final String lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * When the replication set was last updated.
     * </p>
     * 
     * @return When the replication set was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegionMap() {
        return regionMap != null && !(regionMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The map between each Amazon Web Services Region in your replication set and the KMS key that's used to encrypt
     * the data in that Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionMap} method.
     * </p>
     * 
     * @return The map between each Amazon Web Services Region in your replication set and the KMS key that's used to
     *         encrypt the data in that Region.
     */
    public final Map<String, RegionInfo> regionMap() {
        return regionMap;
    }

    /**
     * <p>
     * The status of the replication set. If the replication set is still pending, you can't use Incident Manager
     * functionality.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplicationSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the replication set. If the replication set is still pending, you can't use Incident
     *         Manager functionality.
     * @see ReplicationSetStatus
     */
    public final ReplicationSetStatus status() {
        return ReplicationSetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the replication set. If the replication set is still pending, you can't use Incident Manager
     * functionality.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ReplicationSetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the replication set. If the replication set is still pending, you can't use Incident
     *         Manager functionality.
     * @see ReplicationSetStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtected());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionMap() ? regionMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationSet)) {
            return false;
        }
        ReplicationSet other = (ReplicationSet) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(deletionProtected(), other.deletionProtected())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasRegionMap() == other.hasRegionMap()
                && Objects.equals(regionMap(), other.regionMap()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationSet").add("Arn", arn()).add("CreatedBy", createdBy())
                .add("CreatedTime", createdTime()).add("DeletionProtected", deletionProtected())
                .add("LastModifiedBy", lastModifiedBy()).add("LastModifiedTime", lastModifiedTime())
                .add("RegionMap", hasRegionMap() ? regionMap() : null).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "createdTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "deletionProtected":
            return Optional.ofNullable(clazz.cast(deletionProtected()));
        case "lastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "regionMap":
            return Optional.ofNullable(clazz.cast(regionMap()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationSet, T> g) {
        return obj -> g.apply((ReplicationSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationSet> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication set.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Details about who created the replication set.
         * </p>
         * 
         * @param createdBy
         *        Details about who created the replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * When the replication set was created.
         * </p>
         * 
         * @param createdTime
         *        When the replication set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * Determines if the replication set deletion protection is enabled or not. If deletion protection is enabled,
         * you can't delete the last Amazon Web Services Region in the replication set.
         * </p>
         * 
         * @param deletionProtected
         *        Determines if the replication set deletion protection is enabled or not. If deletion protection is
         *        enabled, you can't delete the last Amazon Web Services Region in the replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtected(Boolean deletionProtected);

        /**
         * <p>
         * Who last modified the replication set.
         * </p>
         * 
         * @param lastModifiedBy
         *        Who last modified the replication set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(String lastModifiedBy);

        /**
         * <p>
         * When the replication set was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the replication set was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The map between each Amazon Web Services Region in your replication set and the KMS key that's used to
         * encrypt the data in that Region.
         * </p>
         * 
         * @param regionMap
         *        The map between each Amazon Web Services Region in your replication set and the KMS key that's used to
         *        encrypt the data in that Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionMap(Map<String, RegionInfo> regionMap);

        /**
         * <p>
         * The status of the replication set. If the replication set is still pending, you can't use Incident Manager
         * functionality.
         * </p>
         * 
         * @param status
         *        The status of the replication set. If the replication set is still pending, you can't use Incident
         *        Manager functionality.
         * @see ReplicationSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationSetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the replication set. If the replication set is still pending, you can't use Incident Manager
         * functionality.
         * </p>
         * 
         * @param status
         *        The status of the replication set. If the replication set is still pending, you can't use Incident
         *        Manager functionality.
         * @see ReplicationSetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationSetStatus
         */
        Builder status(ReplicationSetStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String createdBy;

        private Instant createdTime;

        private Boolean deletionProtected;

        private String lastModifiedBy;

        private Instant lastModifiedTime;

        private Map<String, RegionInfo> regionMap = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationSet model) {
            arn(model.arn);
            createdBy(model.createdBy);
            createdTime(model.createdTime);
            deletionProtected(model.deletionProtected);
            lastModifiedBy(model.lastModifiedBy);
            lastModifiedTime(model.lastModifiedTime);
            regionMap(model.regionMap);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Boolean getDeletionProtected() {
            return deletionProtected;
        }

        public final void setDeletionProtected(Boolean deletionProtected) {
            this.deletionProtected = deletionProtected;
        }

        @Override
        public final Builder deletionProtected(Boolean deletionProtected) {
            this.deletionProtected = deletionProtected;
            return this;
        }

        public final String getLastModifiedBy() {
            return lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, RegionInfo.Builder> getRegionMap() {
            Map<String, RegionInfo.Builder> result = RegionInfoMapCopier.copyToBuilder(this.regionMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRegionMap(Map<String, RegionInfo.BuilderImpl> regionMap) {
            this.regionMap = RegionInfoMapCopier.copyFromBuilder(regionMap);
        }

        @Override
        public final Builder regionMap(Map<String, RegionInfo> regionMap) {
            this.regionMap = RegionInfoMapCopier.copy(regionMap);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReplicationSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ReplicationSet build() {
            return new ReplicationSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
