/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the related item you're adding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedItemsUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedItemsUpdate.Builder, RelatedItemsUpdate> {
    private static final SdkField<RelatedItem> ITEM_TO_ADD_FIELD = SdkField.<RelatedItem> builder(MarshallingType.SDK_POJO)
            .memberName("itemToAdd").getter(getter(RelatedItemsUpdate::itemToAdd)).setter(setter(Builder::itemToAdd))
            .constructor(RelatedItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemToAdd").build()).build();

    private static final SdkField<ItemIdentifier> ITEM_TO_REMOVE_FIELD = SdkField
            .<ItemIdentifier> builder(MarshallingType.SDK_POJO).memberName("itemToRemove")
            .getter(getter(RelatedItemsUpdate::itemToRemove)).setter(setter(Builder::itemToRemove))
            .constructor(ItemIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemToRemove").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_TO_ADD_FIELD,
            ITEM_TO_REMOVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final RelatedItem itemToAdd;

    private final ItemIdentifier itemToRemove;

    private final Type type;

    private RelatedItemsUpdate(BuilderImpl builder) {
        this.itemToAdd = builder.itemToAdd;
        this.itemToRemove = builder.itemToRemove;
        this.type = builder.type;
    }

    /**
     * <p>
     * Details about the related item you're adding.
     * </p>
     * 
     * @return Details about the related item you're adding.
     */
    public final RelatedItem itemToAdd() {
        return itemToAdd;
    }

    /**
     * <p>
     * Details about the related item you're deleting.
     * </p>
     * 
     * @return Details about the related item you're deleting.
     */
    public final ItemIdentifier itemToRemove() {
        return itemToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(itemToAdd());
        hashCode = 31 * hashCode + Objects.hashCode(itemToRemove());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemsUpdate)) {
            return false;
        }
        RelatedItemsUpdate other = (RelatedItemsUpdate) obj;
        return Objects.equals(itemToAdd(), other.itemToAdd()) && Objects.equals(itemToRemove(), other.itemToRemove());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedItemsUpdate").add("ItemToAdd", itemToAdd()).add("ItemToRemove", itemToRemove()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "itemToAdd":
            return Optional.ofNullable(clazz.cast(itemToAdd()));
        case "itemToRemove":
            return Optional.ofNullable(clazz.cast(itemToRemove()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #itemToAdd()} initialized to the given value.
     *
     * <p>
     * Details about the related item you're adding.
     * </p>
     * 
     * @param itemToAdd
     *        Details about the related item you're adding.
     */
    public static RelatedItemsUpdate fromItemToAdd(RelatedItem itemToAdd) {
        return builder().itemToAdd(itemToAdd).build();
    }

    /**
     * Create an instance of this class with {@link #itemToAdd()} initialized to the given value.
     *
     * <p>
     * Details about the related item you're adding.
     * </p>
     * 
     * @param itemToAdd
     *        Details about the related item you're adding.
     */
    public static RelatedItemsUpdate fromItemToAdd(Consumer<RelatedItem.Builder> itemToAdd) {
        RelatedItem.Builder builder = RelatedItem.builder();
        itemToAdd.accept(builder);
        return fromItemToAdd(builder.build());
    }

    /**
     * Create an instance of this class with {@link #itemToRemove()} initialized to the given value.
     *
     * <p>
     * Details about the related item you're deleting.
     * </p>
     * 
     * @param itemToRemove
     *        Details about the related item you're deleting.
     */
    public static RelatedItemsUpdate fromItemToRemove(ItemIdentifier itemToRemove) {
        return builder().itemToRemove(itemToRemove).build();
    }

    /**
     * Create an instance of this class with {@link #itemToRemove()} initialized to the given value.
     *
     * <p>
     * Details about the related item you're deleting.
     * </p>
     * 
     * @param itemToRemove
     *        Details about the related item you're deleting.
     */
    public static RelatedItemsUpdate fromItemToRemove(Consumer<ItemIdentifier.Builder> itemToRemove) {
        ItemIdentifier.Builder builder = ItemIdentifier.builder();
        itemToRemove.accept(builder);
        return fromItemToRemove(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemsUpdate, T> g) {
        return obj -> g.apply((RelatedItemsUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedItemsUpdate> {
        /**
         * <p>
         * Details about the related item you're adding.
         * </p>
         * 
         * @param itemToAdd
         *        Details about the related item you're adding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemToAdd(RelatedItem itemToAdd);

        /**
         * <p>
         * Details about the related item you're adding.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedItem.Builder} avoiding the need to
         * create one manually via {@link RelatedItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedItem.Builder#build()} is called immediately and its result
         * is passed to {@link #itemToAdd(RelatedItem)}.
         * 
         * @param itemToAdd
         *        a consumer that will call methods on {@link RelatedItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemToAdd(RelatedItem)
         */
        default Builder itemToAdd(Consumer<RelatedItem.Builder> itemToAdd) {
            return itemToAdd(RelatedItem.builder().applyMutation(itemToAdd).build());
        }

        /**
         * <p>
         * Details about the related item you're deleting.
         * </p>
         * 
         * @param itemToRemove
         *        Details about the related item you're deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemToRemove(ItemIdentifier itemToRemove);

        /**
         * <p>
         * Details about the related item you're deleting.
         * </p>
         * This is a convenience method that creates an instance of the {@link ItemIdentifier.Builder} avoiding the need
         * to create one manually via {@link ItemIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ItemIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #itemToRemove(ItemIdentifier)}.
         * 
         * @param itemToRemove
         *        a consumer that will call methods on {@link ItemIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #itemToRemove(ItemIdentifier)
         */
        default Builder itemToRemove(Consumer<ItemIdentifier.Builder> itemToRemove) {
            return itemToRemove(ItemIdentifier.builder().applyMutation(itemToRemove).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RelatedItem itemToAdd;

        private ItemIdentifier itemToRemove;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemsUpdate model) {
            itemToAdd(model.itemToAdd);
            itemToRemove(model.itemToRemove);
        }

        public final RelatedItem.Builder getItemToAdd() {
            return itemToAdd != null ? itemToAdd.toBuilder() : null;
        }

        public final void setItemToAdd(RelatedItem.BuilderImpl itemToAdd) {
            Object oldValue = this.itemToAdd;
            this.itemToAdd = itemToAdd != null ? itemToAdd.build() : null;
            handleUnionValueChange(Type.ITEM_TO_ADD, oldValue, this.itemToAdd);
        }

        @Override
        public final Builder itemToAdd(RelatedItem itemToAdd) {
            Object oldValue = this.itemToAdd;
            this.itemToAdd = itemToAdd;
            handleUnionValueChange(Type.ITEM_TO_ADD, oldValue, this.itemToAdd);
            return this;
        }

        public final ItemIdentifier.Builder getItemToRemove() {
            return itemToRemove != null ? itemToRemove.toBuilder() : null;
        }

        public final void setItemToRemove(ItemIdentifier.BuilderImpl itemToRemove) {
            Object oldValue = this.itemToRemove;
            this.itemToRemove = itemToRemove != null ? itemToRemove.build() : null;
            handleUnionValueChange(Type.ITEM_TO_REMOVE, oldValue, this.itemToRemove);
        }

        @Override
        public final Builder itemToRemove(ItemIdentifier itemToRemove) {
            Object oldValue = this.itemToRemove;
            this.itemToRemove = itemToRemove;
            handleUnionValueChange(Type.ITEM_TO_REMOVE, oldValue, this.itemToRemove);
            return this;
        }

        @Override
        public RelatedItemsUpdate build() {
            return new RelatedItemsUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RelatedItemsUpdate#type()
     */
    public enum Type {
        ITEM_TO_ADD,

        ITEM_TO_REMOVE,

        UNKNOWN_TO_SDK_VERSION
    }
}
