/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.SsmParametersCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmTargetAccount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SsmAutomation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SsmAutomation> {
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentName").getter(SsmAutomation.getter(SsmAutomation::documentName)).setter(SsmAutomation.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentVersion").getter(SsmAutomation.getter(SsmAutomation::documentVersion)).setter(SsmAutomation.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentVersion").build()}).build();
    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(SsmAutomation.getter(SsmAutomation::parameters)).setter(SsmAutomation.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(SsmAutomation.getter(SsmAutomation::roleArn)).setter(SsmAutomation.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> TARGET_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetAccount").getter(SsmAutomation.getter(SsmAutomation::targetAccountAsString)).setter(SsmAutomation.setter(Builder::targetAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, PARAMETERS_FIELD, ROLE_ARN_FIELD, TARGET_ACCOUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String documentName;
    private final String documentVersion;
    private final Map<String, List<String>> parameters;
    private final String roleArn;
    private final String targetAccount;

    private SsmAutomation(BuilderImpl builder) {
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.roleArn = builder.roleArn;
        this.targetAccount = builder.targetAccount;
    }

    public final String documentName() {
        return this.documentName;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final SsmTargetAccount targetAccount() {
        return SsmTargetAccount.fromValue(this.targetAccount);
    }

    public final String targetAccountAsString() {
        return this.targetAccount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAccountAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SsmAutomation)) {
            return false;
        }
        SsmAutomation other = (SsmAutomation)obj;
        return Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.targetAccountAsString(), other.targetAccountAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SsmAutomation").add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("RoleArn", (Object)this.roleArn()).add("TargetAccount", (Object)this.targetAccountAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "documentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "documentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "targetAccount": {
                return Optional.ofNullable(clazz.cast(this.targetAccountAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SsmAutomation, T> g) {
        return obj -> g.apply((SsmAutomation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentName;
        private String documentVersion;
        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private String roleArn;
        private String targetAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(SsmAutomation model) {
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.parameters(model.parameters);
            this.roleArn(model.roleArn);
            this.targetAccount(model.targetAccount);
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (this.parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = SsmParametersCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = SsmParametersCopier.copy(parameters);
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTargetAccount() {
            return this.targetAccount;
        }

        public final void setTargetAccount(String targetAccount) {
            this.targetAccount = targetAccount;
        }

        @Override
        public final Builder targetAccount(String targetAccount) {
            this.targetAccount = targetAccount;
            return this;
        }

        @Override
        public final Builder targetAccount(SsmTargetAccount targetAccount) {
            this.targetAccount(targetAccount == null ? null : targetAccount.toString());
            return this;
        }

        public SsmAutomation build() {
            return new SsmAutomation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SsmAutomation> {
        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder parameters(Map<String, ? extends Collection<String>> var1);

        public Builder roleArn(String var1);

        public Builder targetAccount(String var1);

        public Builder targetAccount(SsmTargetAccount var1);
    }
}

