/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.ReplicationSetArnListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReplicationSetsResponse
extends SsmIncidentsResponse
implements ToCopyableBuilder<Builder, ListReplicationSetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReplicationSetsResponse.getter(ListReplicationSetsResponse::nextToken)).setter(ListReplicationSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> REPLICATION_SET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationSetArns").getter(ListReplicationSetsResponse.getter(ListReplicationSetsResponse::replicationSetArns)).setter(ListReplicationSetsResponse.setter(Builder::replicationSetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationSetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REPLICATION_SET_ARNS_FIELD));
    private final String nextToken;
    private final List<String> replicationSetArns;

    private ListReplicationSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.replicationSetArns = builder.replicationSetArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReplicationSetArns() {
        return this.replicationSetArns != null && !(this.replicationSetArns instanceof SdkAutoConstructList);
    }

    public final List<String> replicationSetArns() {
        return this.replicationSetArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationSetArns() ? this.replicationSetArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReplicationSetsResponse)) {
            return false;
        }
        ListReplicationSetsResponse other = (ListReplicationSetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReplicationSetArns() == other.hasReplicationSetArns() && Objects.equals(this.replicationSetArns(), other.replicationSetArns());
    }

    public final String toString() {
        return ToString.builder((String)"ListReplicationSetsResponse").add("NextToken", (Object)this.nextToken()).add("ReplicationSetArns", this.hasReplicationSetArns() ? this.replicationSetArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "replicationSetArns": {
                return Optional.ofNullable(clazz.cast(this.replicationSetArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReplicationSetsResponse, T> g) {
        return obj -> g.apply((ListReplicationSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> replicationSetArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReplicationSetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.replicationSetArns(model.replicationSetArns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getReplicationSetArns() {
            if (this.replicationSetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationSetArns;
        }

        public final void setReplicationSetArns(Collection<String> replicationSetArns) {
            this.replicationSetArns = ReplicationSetArnListCopier.copy(replicationSetArns);
        }

        @Override
        @Transient
        public final Builder replicationSetArns(Collection<String> replicationSetArns) {
            this.replicationSetArns = ReplicationSetArnListCopier.copy(replicationSetArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicationSetArns(String ... replicationSetArns) {
            this.replicationSetArns(Arrays.asList(replicationSetArns));
            return this;
        }

        @Override
        public ListReplicationSetsResponse build() {
            return new ListReplicationSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmIncidentsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReplicationSetsResponse> {
        public Builder nextToken(String var1);

        public Builder replicationSetArns(Collection<String> var1);

        public Builder replicationSetArns(String ... var1);
    }
}

