/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemValue> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ItemValue.getter(ItemValue::arn)).setter(ItemValue.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> METRIC_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricDefinition").getter(ItemValue.getter(ItemValue::metricDefinition)).setter(ItemValue.setter(Builder::metricDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDefinition").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("url").getter(ItemValue.getter(ItemValue::url)).setter(ItemValue.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, METRIC_DEFINITION_FIELD, URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String metricDefinition;
    private final String url;
    private final Type type;

    private ItemValue(BuilderImpl builder) {
        this.arn = builder.arn;
        this.metricDefinition = builder.metricDefinition;
        this.url = builder.url;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final String metricDefinition() {
        return this.metricDefinition;
    }

    public final String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemValue)) {
            return false;
        }
        ItemValue other = (ItemValue)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.metricDefinition(), other.metricDefinition()) && Objects.equals(this.url(), other.url());
    }

    public final String toString() {
        return ToString.builder((String)"ItemValue").add("Arn", (Object)this.arn()).add("MetricDefinition", (Object)this.metricDefinition()).add("Url", (Object)this.url()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "metricDefinition": {
                return Optional.ofNullable(clazz.cast(this.metricDefinition()));
            }
            case "url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    public static ItemValue fromArn(String arn) {
        return (ItemValue)ItemValue.builder().arn(arn).build();
    }

    public static ItemValue fromMetricDefinition(String metricDefinition) {
        return (ItemValue)ItemValue.builder().metricDefinition(metricDefinition).build();
    }

    public static ItemValue fromUrl(String url) {
        return (ItemValue)ItemValue.builder().url(url).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ItemValue, T> g) {
        return obj -> g.apply((ItemValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ARN,
        METRIC_DEFINITION,
        URL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String metricDefinition;
        private String url;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ItemValue model) {
            this.arn(model.arn);
            this.metricDefinition(model.metricDefinition);
            this.url(model.url);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            String oldValue = this.arn;
            this.arn = arn;
            this.handleUnionValueChange(Type.ARN, oldValue, this.arn);
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            String oldValue = this.arn;
            this.arn = arn;
            this.handleUnionValueChange(Type.ARN, oldValue, this.arn);
            return this;
        }

        public final String getMetricDefinition() {
            return this.metricDefinition;
        }

        public final void setMetricDefinition(String metricDefinition) {
            String oldValue = this.metricDefinition;
            this.metricDefinition = metricDefinition;
            this.handleUnionValueChange(Type.METRIC_DEFINITION, oldValue, this.metricDefinition);
        }

        @Override
        @Transient
        public final Builder metricDefinition(String metricDefinition) {
            String oldValue = this.metricDefinition;
            this.metricDefinition = metricDefinition;
            this.handleUnionValueChange(Type.METRIC_DEFINITION, oldValue, this.metricDefinition);
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            String oldValue = this.url;
            this.url = url;
            this.handleUnionValueChange(Type.URL, oldValue, this.url);
        }

        @Override
        @Transient
        public final Builder url(String url) {
            String oldValue = this.url;
            this.url = url;
            this.handleUnionValueChange(Type.URL, oldValue, this.url);
            return this;
        }

        public ItemValue build() {
            return new ItemValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemValue> {
        public Builder arn(String var1);

        public Builder metricDefinition(String var1);

        public Builder url(String var1);
    }
}

