/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmincidents.model.ResourceType;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConflictException
extends SsmIncidentsException
implements ToCopyableBuilder<Builder, ConflictException> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceIdentifier").getter(ConflictException.getter(ConflictException::resourceIdentifier)).setter(ConflictException.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(ConflictException.getter(ConflictException::resourceTypeAsString)).setter(ConflictException.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<Instant> RETRY_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("retryAfter").getter(ConflictException.getter(ConflictException::retryAfter)).setter(ConflictException.setter(Builder::retryAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryAfter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD, RETRY_AFTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceIdentifier;
    private final String resourceType;
    private final Instant retryAfter;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceType = builder.resourceType;
        this.retryAfter = builder.retryAfter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public Instant retryAfter() {
        return this.retryAfter;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsException.BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private String resourceType;
        private Instant retryAfter;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceType(model.resourceType);
            this.retryAfter(model.retryAfter);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        @Transient
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Instant getRetryAfter() {
            return this.retryAfter;
        }

        public final void setRetryAfter(Instant retryAfter) {
            this.retryAfter = retryAfter;
        }

        @Override
        @Transient
        public final Builder retryAfter(Instant retryAfter) {
            this.retryAfter = retryAfter;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConflictException>,
    SsmIncidentsException.Builder {
        public Builder resourceIdentifier(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder retryAfter(Instant var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

