/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.RelatedItem;
import software.amazon.awssdk.services.ssmincidents.model.RelatedItemListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.services.ssmincidents.model.TriggerDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartIncidentRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, StartIncidentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartIncidentRequest.getter(StartIncidentRequest::clientToken)).setter(StartIncidentRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("impact").getter(StartIncidentRequest.getter(StartIncidentRequest::impact)).setter(StartIncidentRequest.setter(Builder::impact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impact").build()}).build();
    private static final SdkField<List<RelatedItem>> RELATED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedItems").getter(StartIncidentRequest.getter(StartIncidentRequest::relatedItems)).setter(StartIncidentRequest.setter(Builder::relatedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelatedItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESPONSE_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responsePlanArn").getter(StartIncidentRequest.getter(StartIncidentRequest::responsePlanArn)).setter(StartIncidentRequest.setter(Builder::responsePlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responsePlanArn").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(StartIncidentRequest.getter(StartIncidentRequest::title)).setter(StartIncidentRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<TriggerDetails> TRIGGER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("triggerDetails").getter(StartIncidentRequest.getter(StartIncidentRequest::triggerDetails)).setter(StartIncidentRequest.setter(Builder::triggerDetails)).constructor(TriggerDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, IMPACT_FIELD, RELATED_ITEMS_FIELD, RESPONSE_PLAN_ARN_FIELD, TITLE_FIELD, TRIGGER_DETAILS_FIELD));
    private final String clientToken;
    private final Integer impact;
    private final List<RelatedItem> relatedItems;
    private final String responsePlanArn;
    private final String title;
    private final TriggerDetails triggerDetails;

    private StartIncidentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.impact = builder.impact;
        this.relatedItems = builder.relatedItems;
        this.responsePlanArn = builder.responsePlanArn;
        this.title = builder.title;
        this.triggerDetails = builder.triggerDetails;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer impact() {
        return this.impact;
    }

    public final boolean hasRelatedItems() {
        return this.relatedItems != null && !(this.relatedItems instanceof SdkAutoConstructList);
    }

    public final List<RelatedItem> relatedItems() {
        return this.relatedItems;
    }

    public final String responsePlanArn() {
        return this.responsePlanArn;
    }

    public final String title() {
        return this.title;
    }

    public final TriggerDetails triggerDetails() {
        return this.triggerDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.impact());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedItems() ? this.relatedItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responsePlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIncidentRequest)) {
            return false;
        }
        StartIncidentRequest other = (StartIncidentRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.impact(), other.impact()) && this.hasRelatedItems() == other.hasRelatedItems() && Objects.equals(this.relatedItems(), other.relatedItems()) && Objects.equals(this.responsePlanArn(), other.responsePlanArn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.triggerDetails(), other.triggerDetails());
    }

    public final String toString() {
        return ToString.builder((String)"StartIncidentRequest").add("ClientToken", (Object)this.clientToken()).add("Impact", (Object)this.impact()).add("RelatedItems", this.hasRelatedItems() ? this.relatedItems() : null).add("ResponsePlanArn", (Object)this.responsePlanArn()).add("Title", (Object)this.title()).add("TriggerDetails", (Object)this.triggerDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "impact": {
                return Optional.ofNullable(clazz.cast(this.impact()));
            }
            case "relatedItems": {
                return Optional.ofNullable(clazz.cast(this.relatedItems()));
            }
            case "responsePlanArn": {
                return Optional.ofNullable(clazz.cast(this.responsePlanArn()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "triggerDetails": {
                return Optional.ofNullable(clazz.cast(this.triggerDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartIncidentRequest, T> g) {
        return obj -> g.apply((StartIncidentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private Integer impact;
        private List<RelatedItem> relatedItems = DefaultSdkAutoConstructList.getInstance();
        private String responsePlanArn;
        private String title;
        private TriggerDetails triggerDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StartIncidentRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.impact(model.impact);
            this.relatedItems(model.relatedItems);
            this.responsePlanArn(model.responsePlanArn);
            this.title(model.title);
            this.triggerDetails(model.triggerDetails);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getImpact() {
            return this.impact;
        }

        public final void setImpact(Integer impact) {
            this.impact = impact;
        }

        @Override
        @Transient
        public final Builder impact(Integer impact) {
            this.impact = impact;
            return this;
        }

        public final List<RelatedItem.Builder> getRelatedItems() {
            List<RelatedItem.Builder> result = RelatedItemListCopier.copyToBuilder(this.relatedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedItems(Collection<RelatedItem.BuilderImpl> relatedItems) {
            this.relatedItems = RelatedItemListCopier.copyFromBuilder(relatedItems);
        }

        @Override
        @Transient
        public final Builder relatedItems(Collection<RelatedItem> relatedItems) {
            this.relatedItems = RelatedItemListCopier.copy(relatedItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder relatedItems(RelatedItem ... relatedItems) {
            this.relatedItems(Arrays.asList(relatedItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder relatedItems(Consumer<RelatedItem.Builder> ... relatedItems) {
            this.relatedItems(Stream.of(relatedItems).map(c -> (RelatedItem)((RelatedItem.Builder)RelatedItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResponsePlanArn() {
            return this.responsePlanArn;
        }

        public final void setResponsePlanArn(String responsePlanArn) {
            this.responsePlanArn = responsePlanArn;
        }

        @Override
        @Transient
        public final Builder responsePlanArn(String responsePlanArn) {
            this.responsePlanArn = responsePlanArn;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final TriggerDetails.Builder getTriggerDetails() {
            return this.triggerDetails != null ? this.triggerDetails.toBuilder() : null;
        }

        public final void setTriggerDetails(TriggerDetails.BuilderImpl triggerDetails) {
            this.triggerDetails = triggerDetails != null ? triggerDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder triggerDetails(TriggerDetails triggerDetails) {
            this.triggerDetails = triggerDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartIncidentRequest build() {
            return new StartIncidentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartIncidentRequest> {
        public Builder clientToken(String var1);

        public Builder impact(Integer var1);

        public Builder relatedItems(Collection<RelatedItem> var1);

        public Builder relatedItems(RelatedItem ... var1);

        public Builder relatedItems(Consumer<RelatedItem.Builder> ... var1);

        public Builder responsePlanArn(String var1);

        public Builder title(String var1);

        public Builder triggerDetails(TriggerDetails var1);

        default public Builder triggerDetails(Consumer<TriggerDetails.Builder> triggerDetails) {
            return this.triggerDetails((TriggerDetails)((TriggerDetails.Builder)TriggerDetails.builder().applyMutation(triggerDetails)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

