/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddRegionAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddRegionAction> {
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionName").getter(AddRegionAction.getter(AddRegionAction::regionName)).setter(AddRegionAction.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<String> SSE_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sseKmsKeyId").getter(AddRegionAction.getter(AddRegionAction::sseKmsKeyId)).setter(AddRegionAction.setter(Builder::sseKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseKmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAME_FIELD, SSE_KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String regionName;
    private final String sseKmsKeyId;

    private AddRegionAction(BuilderImpl builder) {
        this.regionName = builder.regionName;
        this.sseKmsKeyId = builder.sseKmsKeyId;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final String sseKmsKeyId() {
        return this.sseKmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseKmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddRegionAction)) {
            return false;
        }
        AddRegionAction other = (AddRegionAction)obj;
        return Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.sseKmsKeyId(), other.sseKmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"AddRegionAction").add("RegionName", (Object)this.regionName()).add("SseKmsKeyId", (Object)this.sseKmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "regionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "sseKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.sseKmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddRegionAction, T> g) {
        return obj -> g.apply((AddRegionAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String regionName;
        private String sseKmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(AddRegionAction model) {
            this.regionName(model.regionName);
            this.sseKmsKeyId(model.sseKmsKeyId);
        }

        public final String getRegionName() {
            return this.regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getSseKmsKeyId() {
            return this.sseKmsKeyId;
        }

        @Override
        public final Builder sseKmsKeyId(String sseKmsKeyId) {
            this.sseKmsKeyId = sseKmsKeyId;
            return this;
        }

        public final void setSseKmsKeyId(String sseKmsKeyId) {
            this.sseKmsKeyId = sseKmsKeyId;
        }

        public AddRegionAction build() {
            return new AddRegionAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddRegionAction> {
        public Builder regionName(String var1);

        public Builder sseKmsKeyId(String var1);
    }
}

