/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTimelineEventResponse
extends SsmIncidentsResponse
implements ToCopyableBuilder<Builder, CreateTimelineEventResponse> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(CreateTimelineEventResponse.getter(CreateTimelineEventResponse::eventId)).setter(CreateTimelineEventResponse.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> INCIDENT_RECORD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("incidentRecordArn").getter(CreateTimelineEventResponse.getter(CreateTimelineEventResponse::incidentRecordArn)).setter(CreateTimelineEventResponse.setter(Builder::incidentRecordArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentRecordArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, INCIDENT_RECORD_ARN_FIELD));
    private final String eventId;
    private final String incidentRecordArn;

    private CreateTimelineEventResponse(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.incidentRecordArn = builder.incidentRecordArn;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String incidentRecordArn() {
        return this.incidentRecordArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentRecordArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTimelineEventResponse)) {
            return false;
        }
        CreateTimelineEventResponse other = (CreateTimelineEventResponse)((Object)obj);
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.incidentRecordArn(), other.incidentRecordArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTimelineEventResponse").add("EventId", (Object)this.eventId()).add("IncidentRecordArn", (Object)this.incidentRecordArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "incidentRecordArn": {
                return Optional.ofNullable(clazz.cast(this.incidentRecordArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTimelineEventResponse, T> g) {
        return obj -> g.apply((CreateTimelineEventResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsResponse.BuilderImpl
    implements Builder {
        private String eventId;
        private String incidentRecordArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTimelineEventResponse model) {
            super(model);
            this.eventId(model.eventId);
            this.incidentRecordArn(model.incidentRecordArn);
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getIncidentRecordArn() {
            return this.incidentRecordArn;
        }

        @Override
        public final Builder incidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
            return this;
        }

        public final void setIncidentRecordArn(String incidentRecordArn) {
            this.incidentRecordArn = incidentRecordArn;
        }

        @Override
        public CreateTimelineEventResponse build() {
            return new CreateTimelineEventResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmIncidentsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTimelineEventResponse> {
        public Builder eventId(String var1);

        public Builder incidentRecordArn(String var1);
    }
}

