/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopEngagementRequest extends SsmContactsRequest implements
        ToCopyableBuilder<StopEngagementRequest.Builder, StopEngagementRequest> {
    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementId").getter(getter(StopEngagementRequest::engagementId)).setter(setter(Builder::engagementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(StopEngagementRequest::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGAGEMENT_ID_FIELD,
            REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String engagementId;

    private final String reason;

    private StopEngagementRequest(BuilderImpl builder) {
        super(builder);
        this.engagementId = builder.engagementId;
        this.reason = builder.reason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the engagement.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the engagement.
     */
    public final String engagementId() {
        return engagementId;
    }

    /**
     * <p>
     * The reason that you're stopping the engagement.
     * </p>
     * 
     * @return The reason that you're stopping the engagement.
     */
    public final String reason() {
        return reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopEngagementRequest)) {
            return false;
        }
        StopEngagementRequest other = (StopEngagementRequest) obj;
        return Objects.equals(engagementId(), other.engagementId()) && Objects.equals(reason(), other.reason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopEngagementRequest").add("EngagementId", engagementId()).add("Reason", reason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngagementId":
            return Optional.ofNullable(clazz.cast(engagementId()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngagementId", ENGAGEMENT_ID_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StopEngagementRequest, T> g) {
        return obj -> g.apply((StopEngagementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StopEngagementRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the engagement.
         * </p>
         * 
         * @param engagementId
         *        The Amazon Resource Name (ARN) of the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementId(String engagementId);

        /**
         * <p>
         * The reason that you're stopping the engagement.
         * </p>
         * 
         * @param reason
         *        The reason that you're stopping the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String engagementId;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(StopEngagementRequest model) {
            super(model);
            engagementId(model.engagementId);
            reason(model.reason);
        }

        public final String getEngagementId() {
            return engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StopEngagementRequest build() {
            return new StopEngagementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
