/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a rotation in an on-call schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rotation implements SdkPojo, Serializable, ToCopyableBuilder<Rotation.Builder, Rotation> {
    private static final SdkField<String> ROTATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationArn").getter(getter(Rotation::rotationArn)).setter(setter(Builder::rotationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Rotation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> CONTACT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContactIds")
            .getter(getter(Rotation::contactIds))
            .setter(setter(Builder::contactIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(Rotation::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZoneId").getter(getter(Rotation::timeZoneId)).setter(setter(Builder::timeZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()).build();

    private static final SdkField<RecurrenceSettings> RECURRENCE_FIELD = SdkField
            .<RecurrenceSettings> builder(MarshallingType.SDK_POJO).memberName("Recurrence").getter(getter(Rotation::recurrence))
            .setter(setter(Builder::recurrence)).constructor(RecurrenceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_ARN_FIELD,
            NAME_FIELD, CONTACT_IDS_FIELD, START_TIME_FIELD, TIME_ZONE_ID_FIELD, RECURRENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String rotationArn;

    private final String name;

    private final List<String> contactIds;

    private final Instant startTime;

    private final String timeZoneId;

    private final RecurrenceSettings recurrence;

    private Rotation(BuilderImpl builder) {
        this.rotationArn = builder.rotationArn;
        this.name = builder.name;
        this.contactIds = builder.contactIds;
        this.startTime = builder.startTime;
        this.timeZoneId = builder.timeZoneId;
        this.recurrence = builder.recurrence;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rotation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rotation.
     */
    public final String rotationArn() {
        return rotationArn;
    }

    /**
     * <p>
     * The name of the rotation.
     * </p>
     * 
     * @return The name of the rotation.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContactIds() {
        return contactIds != null && !(contactIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the contacts assigned to the rotation team.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactIds} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the contacts assigned to the rotation team.
     */
    public final List<String> contactIds() {
        return contactIds;
    }

    /**
     * <p>
     * The date and time the rotation becomes active.
     * </p>
     * 
     * @return The date and time the rotation becomes active.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time zone the rotation’s activity is based on, in Internet Assigned Numbers Authority (IANA) format. For
     * example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
     * </p>
     * 
     * @return The time zone the rotation’s activity is based on, in Internet Assigned Numbers Authority (IANA) format.
     *         For example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
     */
    public final String timeZoneId() {
        return timeZoneId;
    }

    /**
     * <p>
     * Information about when an on-call rotation is in effect and how long the rotation period lasts.
     * </p>
     * 
     * @return Information about when an on-call rotation is in effect and how long the rotation period lasts.
     */
    public final RecurrenceSettings recurrence() {
        return recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(rotationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasContactIds() ? contactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rotation)) {
            return false;
        }
        Rotation other = (Rotation) obj;
        return Objects.equals(rotationArn(), other.rotationArn()) && Objects.equals(name(), other.name())
                && hasContactIds() == other.hasContactIds() && Objects.equals(contactIds(), other.contactIds())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(timeZoneId(), other.timeZoneId())
                && Objects.equals(recurrence(), other.recurrence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rotation").add("RotationArn", rotationArn()).add("Name", name())
                .add("ContactIds", hasContactIds() ? contactIds() : null).add("StartTime", startTime())
                .add("TimeZoneId", timeZoneId()).add("Recurrence", recurrence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RotationArn":
            return Optional.ofNullable(clazz.cast(rotationArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ContactIds":
            return Optional.ofNullable(clazz.cast(contactIds()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "TimeZoneId":
            return Optional.ofNullable(clazz.cast(timeZoneId()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RotationArn", ROTATION_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ContactIds", CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("TimeZoneId", TIME_ZONE_ID_FIELD);
        map.put("Recurrence", RECURRENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Rotation, T> g) {
        return obj -> g.apply((Rotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rotation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rotation.
         * </p>
         * 
         * @param rotationArn
         *        The Amazon Resource Name (ARN) of the rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationArn(String rotationArn);

        /**
         * <p>
         * The name of the rotation.
         * </p>
         * 
         * @param name
         *        The name of the rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts assigned to the rotation team.
         * </p>
         * 
         * @param contactIds
         *        The Amazon Resource Names (ARNs) of the contacts assigned to the rotation team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactIds(Collection<String> contactIds);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts assigned to the rotation team.
         * </p>
         * 
         * @param contactIds
         *        The Amazon Resource Names (ARNs) of the contacts assigned to the rotation team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactIds(String... contactIds);

        /**
         * <p>
         * The date and time the rotation becomes active.
         * </p>
         * 
         * @param startTime
         *        The date and time the rotation becomes active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time zone the rotation’s activity is based on, in Internet Assigned Numbers Authority (IANA) format. For
         * example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
         * </p>
         * 
         * @param timeZoneId
         *        The time zone the rotation’s activity is based on, in Internet Assigned Numbers Authority (IANA)
         *        format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZoneId(String timeZoneId);

        /**
         * <p>
         * Information about when an on-call rotation is in effect and how long the rotation period lasts.
         * </p>
         * 
         * @param recurrence
         *        Information about when an on-call rotation is in effect and how long the rotation period lasts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(RecurrenceSettings recurrence);

        /**
         * <p>
         * Information about when an on-call rotation is in effect and how long the rotation period lasts.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecurrenceSettings.Builder} avoiding the
         * need to create one manually via {@link RecurrenceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecurrenceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #recurrence(RecurrenceSettings)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link RecurrenceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(RecurrenceSettings)
         */
        default Builder recurrence(Consumer<RecurrenceSettings.Builder> recurrence) {
            return recurrence(RecurrenceSettings.builder().applyMutation(recurrence).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String rotationArn;

        private String name;

        private List<String> contactIds = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private String timeZoneId;

        private RecurrenceSettings recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(Rotation model) {
            rotationArn(model.rotationArn);
            name(model.name);
            contactIds(model.contactIds);
            startTime(model.startTime);
            timeZoneId(model.timeZoneId);
            recurrence(model.recurrence);
        }

        public final String getRotationArn() {
            return rotationArn;
        }

        public final void setRotationArn(String rotationArn) {
            this.rotationArn = rotationArn;
        }

        @Override
        public final Builder rotationArn(String rotationArn) {
            this.rotationArn = rotationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getContactIds() {
            if (contactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return contactIds;
        }

        public final void setContactIds(Collection<String> contactIds) {
            this.contactIds = SsmContactsArnListCopier.copy(contactIds);
        }

        @Override
        public final Builder contactIds(Collection<String> contactIds) {
            this.contactIds = SsmContactsArnListCopier.copy(contactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactIds(String... contactIds) {
            contactIds(Arrays.asList(contactIds));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTimeZoneId() {
            return timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final RecurrenceSettings.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        public final void setRecurrence(RecurrenceSettings.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(RecurrenceSettings recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        @Override
        public Rotation build() {
            return new Rotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
