/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the engagement resolution steps. The resolution starts from the first contact, which can be an
 * escalation plan, then resolves to an on-call rotation, and finally to a personal contact.
 * </p>
 * <p>
 * The <code>ResolutionContact</code> structure describes the information for each node or step in that process. It
 * contains information about different contact types, such as the escalation, rotation, and personal contacts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolutionContact implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolutionContact.Builder, ResolutionContact> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(ResolutionContact::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ResolutionContact::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Integer> STAGE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StageIndex").getter(getter(ResolutionContact::stageIndex)).setter(setter(Builder::stageIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, TYPE_FIELD,
            STAGE_INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactArn;

    private final String type;

    private final Integer stageIndex;

    private ResolutionContact(BuilderImpl builder) {
        this.contactArn = builder.contactArn;
        this.type = builder.type;
        this.stageIndex = builder.stageIndex;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a contact in the engagement resolution process.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a contact in the engagement resolution process.
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The type of contact for a resolution step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of contact for a resolution step.
     * @see ContactType
     */
    public final ContactType type() {
        return ContactType.fromValue(type);
    }

    /**
     * <p>
     * The type of contact for a resolution step.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ContactType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of contact for a resolution step.
     * @see ContactType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The stage in the escalation plan that resolves to this contact.
     * </p>
     * 
     * @return The stage in the escalation plan that resolves to this contact.
     */
    public final Integer stageIndex() {
        return stageIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stageIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolutionContact)) {
            return false;
        }
        ResolutionContact other = (ResolutionContact) obj;
        return Objects.equals(contactArn(), other.contactArn()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(stageIndex(), other.stageIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolutionContact").add("ContactArn", contactArn()).add("Type", typeAsString())
                .add("StageIndex", stageIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "StageIndex":
            return Optional.ofNullable(clazz.cast(stageIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactArn", CONTACT_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("StageIndex", STAGE_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolutionContact, T> g) {
        return obj -> g.apply((ResolutionContact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolutionContact> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a contact in the engagement resolution process.
         * </p>
         * 
         * @param contactArn
         *        The Amazon Resource Name (ARN) of a contact in the engagement resolution process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The type of contact for a resolution step.
         * </p>
         * 
         * @param type
         *        The type of contact for a resolution step.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of contact for a resolution step.
         * </p>
         * 
         * @param type
         *        The type of contact for a resolution step.
         * @see ContactType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContactType
         */
        Builder type(ContactType type);

        /**
         * <p>
         * The stage in the escalation plan that resolves to this contact.
         * </p>
         * 
         * @param stageIndex
         *        The stage in the escalation plan that resolves to this contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageIndex(Integer stageIndex);
    }

    static final class BuilderImpl implements Builder {
        private String contactArn;

        private String type;

        private Integer stageIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolutionContact model) {
            contactArn(model.contactArn);
            type(model.type);
            stageIndex(model.stageIndex);
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getStageIndex() {
            return stageIndex;
        }

        public final void setStageIndex(Integer stageIndex) {
            this.stageIndex = stageIndex;
        }

        @Override
        public final Builder stageIndex(Integer stageIndex) {
            this.stageIndex = stageIndex;
            return this;
        }

        @Override
        public ResolutionContact build() {
            return new ResolutionContact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
