/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the stages and on-call rotation teams associated with an escalation plan or engagement plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Plan implements SdkPojo, Serializable, ToCopyableBuilder<Plan.Builder, Plan> {
    private static final SdkField<List<Stage>> STAGES_FIELD = SdkField
            .<List<Stage>> builder(MarshallingType.LIST)
            .memberName("Stages")
            .getter(getter(Plan::stages))
            .setter(setter(Builder::stages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Stage> builder(MarshallingType.SDK_POJO)
                                            .constructor(Stage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ROTATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RotationIds")
            .getter(getter(Plan::rotationIds))
            .setter(setter(Builder::rotationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGES_FIELD,
            ROTATION_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Stage> stages;

    private final List<String> rotationIds;

    private Plan(BuilderImpl builder) {
        this.stages = builder.stages;
        this.rotationIds = builder.rotationIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Stages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStages() {
        return stages != null && !(stages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStages} method.
     * </p>
     * 
     * @return A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
     */
    public final List<Stage> stages() {
        return stages;
    }

    /**
     * For responses, this returns true if the service returned a value for the RotationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRotationIds() {
        return rotationIds != null && !(rotationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRotationIds} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
     */
    public final List<String> rotationIds() {
        return rotationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStages() ? stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRotationIds() ? rotationIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Plan)) {
            return false;
        }
        Plan other = (Plan) obj;
        return hasStages() == other.hasStages() && Objects.equals(stages(), other.stages())
                && hasRotationIds() == other.hasRotationIds() && Objects.equals(rotationIds(), other.rotationIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Plan").add("Stages", hasStages() ? stages() : null)
                .add("RotationIds", hasRotationIds() ? rotationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stages":
            return Optional.ofNullable(clazz.cast(stages()));
        case "RotationIds":
            return Optional.ofNullable(clazz.cast(rotationIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Stages", STAGES_FIELD);
        map.put("RotationIds", ROTATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Plan, T> g) {
        return obj -> g.apply((Plan) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Plan> {
        /**
         * <p>
         * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * </p>
         * 
         * @param stages
         *        A list of stages that the escalation plan or engagement plan uses to engage contacts and contact
         *        methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Collection<Stage> stages);

        /**
         * <p>
         * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * </p>
         * 
         * @param stages
         *        A list of stages that the escalation plan or engagement plan uses to engage contacts and contact
         *        methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Stage... stages);

        /**
         * <p>
         * A list of stages that the escalation plan or engagement plan uses to engage contacts and contact methods.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.Stage.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmcontacts.model.Stage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.Stage.Builder#build()} is called immediately and its
         * result is passed to {@link #stages(List<Stage>)}.
         * 
         * @param stages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.Stage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stages(java.util.Collection<Stage>)
         */
        Builder stages(Consumer<Stage.Builder>... stages);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
         * </p>
         * 
         * @param rotationIds
         *        The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationIds(Collection<String> rotationIds);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
         * </p>
         * 
         * @param rotationIds
         *        The Amazon Resource Names (ARNs) of the on-call rotations associated with the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationIds(String... rotationIds);
    }

    static final class BuilderImpl implements Builder {
        private List<Stage> stages = DefaultSdkAutoConstructList.getInstance();

        private List<String> rotationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Plan model) {
            stages(model.stages);
            rotationIds(model.rotationIds);
        }

        public final List<Stage.Builder> getStages() {
            List<Stage.Builder> result = StagesListCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStages(Collection<Stage.BuilderImpl> stages) {
            this.stages = StagesListCopier.copyFromBuilder(stages);
        }

        @Override
        public final Builder stages(Collection<Stage> stages) {
            this.stages = StagesListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Stage... stages) {
            stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<Stage.Builder>... stages) {
            stages(Stream.of(stages).map(c -> Stage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getRotationIds() {
            if (rotationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return rotationIds;
        }

        public final void setRotationIds(Collection<String> rotationIds) {
            this.rotationIds = SsmContactsArnListCopier.copy(rotationIds);
        }

        @Override
        public final Builder rotationIds(Collection<String> rotationIds) {
            this.rotationIds = SsmContactsArnListCopier.copy(rotationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rotationIds(String... rotationIds) {
            rotationIds(Arrays.asList(rotationIds));
            return this;
        }

        @Override
        public Plan build() {
            return new Plan(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
