/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about on-call rotations that recur monthly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonthlySetting implements SdkPojo, Serializable, ToCopyableBuilder<MonthlySetting.Builder, MonthlySetting> {
    private static final SdkField<Integer> DAY_OF_MONTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DayOfMonth").getter(getter(MonthlySetting::dayOfMonth)).setter(setter(Builder::dayOfMonth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfMonth").build()).build();

    private static final SdkField<HandOffTime> HAND_OFF_TIME_FIELD = SdkField.<HandOffTime> builder(MarshallingType.SDK_POJO)
            .memberName("HandOffTime").getter(getter(MonthlySetting::handOffTime)).setter(setter(Builder::handOffTime))
            .constructor(HandOffTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HandOffTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_MONTH_FIELD,
            HAND_OFF_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dayOfMonth;

    private final HandOffTime handOffTime;

    private MonthlySetting(BuilderImpl builder) {
        this.dayOfMonth = builder.dayOfMonth;
        this.handOffTime = builder.handOffTime;
    }

    /**
     * <p>
     * The day of the month when monthly recurring on-call rotations begin.
     * </p>
     * 
     * @return The day of the month when monthly recurring on-call rotations begin.
     */
    public final Integer dayOfMonth() {
        return dayOfMonth;
    }

    /**
     * <p>
     * The time of day when a monthly recurring on-call shift rotation begins.
     * </p>
     * 
     * @return The time of day when a monthly recurring on-call shift rotation begins.
     */
    public final HandOffTime handOffTime() {
        return handOffTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayOfMonth());
        hashCode = 31 * hashCode + Objects.hashCode(handOffTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonthlySetting)) {
            return false;
        }
        MonthlySetting other = (MonthlySetting) obj;
        return Objects.equals(dayOfMonth(), other.dayOfMonth()) && Objects.equals(handOffTime(), other.handOffTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonthlySetting").add("DayOfMonth", dayOfMonth()).add("HandOffTime", handOffTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DayOfMonth":
            return Optional.ofNullable(clazz.cast(dayOfMonth()));
        case "HandOffTime":
            return Optional.ofNullable(clazz.cast(handOffTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DayOfMonth", DAY_OF_MONTH_FIELD);
        map.put("HandOffTime", HAND_OFF_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonthlySetting, T> g) {
        return obj -> g.apply((MonthlySetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonthlySetting> {
        /**
         * <p>
         * The day of the month when monthly recurring on-call rotations begin.
         * </p>
         * 
         * @param dayOfMonth
         *        The day of the month when monthly recurring on-call rotations begin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dayOfMonth(Integer dayOfMonth);

        /**
         * <p>
         * The time of day when a monthly recurring on-call shift rotation begins.
         * </p>
         * 
         * @param handOffTime
         *        The time of day when a monthly recurring on-call shift rotation begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handOffTime(HandOffTime handOffTime);

        /**
         * <p>
         * The time of day when a monthly recurring on-call shift rotation begins.
         * </p>
         * This is a convenience method that creates an instance of the {@link HandOffTime.Builder} avoiding the need to
         * create one manually via {@link HandOffTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HandOffTime.Builder#build()} is called immediately and its result
         * is passed to {@link #handOffTime(HandOffTime)}.
         * 
         * @param handOffTime
         *        a consumer that will call methods on {@link HandOffTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #handOffTime(HandOffTime)
         */
        default Builder handOffTime(Consumer<HandOffTime.Builder> handOffTime) {
            return handOffTime(HandOffTime.builder().applyMutation(handOffTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer dayOfMonth;

        private HandOffTime handOffTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MonthlySetting model) {
            dayOfMonth(model.dayOfMonth);
            handOffTime(model.handOffTime);
        }

        public final Integer getDayOfMonth() {
            return dayOfMonth;
        }

        public final void setDayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
        }

        @Override
        public final Builder dayOfMonth(Integer dayOfMonth) {
            this.dayOfMonth = dayOfMonth;
            return this;
        }

        public final HandOffTime.Builder getHandOffTime() {
            return handOffTime != null ? handOffTime.toBuilder() : null;
        }

        public final void setHandOffTime(HandOffTime.BuilderImpl handOffTime) {
            this.handOffTime = handOffTime != null ? handOffTime.build() : null;
        }

        @Override
        public final Builder handOffTime(HandOffTime handOffTime) {
            this.handOffTime = handOffTime;
            return this;
        }

        @Override
        public MonthlySetting build() {
            return new MonthlySetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
