/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRotationOverrideRequest extends SsmContactsRequest implements
        ToCopyableBuilder<DeleteRotationOverrideRequest.Builder, DeleteRotationOverrideRequest> {
    private static final SdkField<String> ROTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationId").getter(getter(DeleteRotationOverrideRequest::rotationId))
            .setter(setter(Builder::rotationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationId").build()).build();

    private static final SdkField<String> ROTATION_OVERRIDE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationOverrideId").getter(getter(DeleteRotationOverrideRequest::rotationOverrideId))
            .setter(setter(Builder::rotationOverrideId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationOverrideId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_ID_FIELD,
            ROTATION_OVERRIDE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String rotationId;

    private final String rotationOverrideId;

    private DeleteRotationOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.rotationId = builder.rotationId;
        this.rotationOverrideId = builder.rotationOverrideId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rotation that was overridden.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rotation that was overridden.
     */
    public final String rotationId() {
        return rotationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the on-call rotation override to delete.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the on-call rotation override to delete.
     */
    public final String rotationOverrideId() {
        return rotationOverrideId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rotationId());
        hashCode = 31 * hashCode + Objects.hashCode(rotationOverrideId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRotationOverrideRequest)) {
            return false;
        }
        DeleteRotationOverrideRequest other = (DeleteRotationOverrideRequest) obj;
        return Objects.equals(rotationId(), other.rotationId())
                && Objects.equals(rotationOverrideId(), other.rotationOverrideId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRotationOverrideRequest").add("RotationId", rotationId())
                .add("RotationOverrideId", rotationOverrideId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RotationId":
            return Optional.ofNullable(clazz.cast(rotationId()));
        case "RotationOverrideId":
            return Optional.ofNullable(clazz.cast(rotationOverrideId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RotationId", ROTATION_ID_FIELD);
        map.put("RotationOverrideId", ROTATION_OVERRIDE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteRotationOverrideRequest, T> g) {
        return obj -> g.apply((DeleteRotationOverrideRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteRotationOverrideRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rotation that was overridden.
         * </p>
         * 
         * @param rotationId
         *        The Amazon Resource Name (ARN) of the rotation that was overridden.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationId(String rotationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the on-call rotation override to delete.
         * </p>
         * 
         * @param rotationOverrideId
         *        The Amazon Resource Name (ARN) of the on-call rotation override to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationOverrideId(String rotationOverrideId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String rotationId;

        private String rotationOverrideId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRotationOverrideRequest model) {
            super(model);
            rotationId(model.rotationId);
            rotationOverrideId(model.rotationOverrideId);
        }

        public final String getRotationId() {
            return rotationId;
        }

        public final void setRotationId(String rotationId) {
            this.rotationId = rotationId;
        }

        @Override
        public final Builder rotationId(String rotationId) {
            this.rotationId = rotationId;
            return this;
        }

        public final String getRotationOverrideId() {
            return rotationOverrideId;
        }

        public final void setRotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
        }

        @Override
        public final Builder rotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRotationOverrideRequest build() {
            return new DeleteRotationOverrideRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
