/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRotationOverrideRequest extends SsmContactsRequest implements
        ToCopyableBuilder<CreateRotationOverrideRequest.Builder, CreateRotationOverrideRequest> {
    private static final SdkField<String> ROTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationId").getter(getter(CreateRotationOverrideRequest::rotationId))
            .setter(setter(Builder::rotationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationId").build()).build();

    private static final SdkField<List<String>> NEW_CONTACT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NewContactIds")
            .getter(getter(CreateRotationOverrideRequest::newContactIds))
            .setter(setter(Builder::newContactIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewContactIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(CreateRotationOverrideRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(CreateRotationOverrideRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken").getter(getter(CreateRotationOverrideRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_ID_FIELD,
            NEW_CONTACT_IDS_FIELD, START_TIME_FIELD, END_TIME_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String rotationId;

    private final List<String> newContactIds;

    private final Instant startTime;

    private final Instant endTime;

    private final String idempotencyToken;

    private CreateRotationOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.rotationId = builder.rotationId;
        this.newContactIds = builder.newContactIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rotation to create an override for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rotation to create an override for.
     */
    public final String rotationId() {
        return rotationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the NewContactIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNewContactIds() {
        return newContactIds != null && !(newContactIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the contacts to replace those in the current on-call rotation with.
     * </p>
     * <p>
     * If you want to include any current team members in the override shift, you must include their ARNs in the new
     * contact ID list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNewContactIds} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the contacts to replace those in the current on-call rotation
     *         with.</p>
     *         <p>
     *         If you want to include any current team members in the override shift, you must include their ARNs in the
     *         new contact ID list.
     */
    public final List<String> newContactIds() {
        return newContactIds;
    }

    /**
     * <p>
     * The date and time when the override goes into effect.
     * </p>
     * 
     * @return The date and time when the override goes into effect.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time when the override ends.
     * </p>
     * 
     * @return The date and time when the override ends.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * A token that ensures that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token that ensures that the operation is called only once with the specified details.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rotationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasNewContactIds() ? newContactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRotationOverrideRequest)) {
            return false;
        }
        CreateRotationOverrideRequest other = (CreateRotationOverrideRequest) obj;
        return Objects.equals(rotationId(), other.rotationId()) && hasNewContactIds() == other.hasNewContactIds()
                && Objects.equals(newContactIds(), other.newContactIds()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRotationOverrideRequest").add("RotationId", rotationId())
                .add("NewContactIds", hasNewContactIds() ? newContactIds() : null).add("StartTime", startTime())
                .add("EndTime", endTime()).add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RotationId":
            return Optional.ofNullable(clazz.cast(rotationId()));
        case "NewContactIds":
            return Optional.ofNullable(clazz.cast(newContactIds()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RotationId", ROTATION_ID_FIELD);
        map.put("NewContactIds", NEW_CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRotationOverrideRequest, T> g) {
        return obj -> g.apply((CreateRotationOverrideRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRotationOverrideRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rotation to create an override for.
         * </p>
         * 
         * @param rotationId
         *        The Amazon Resource Name (ARN) of the rotation to create an override for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationId(String rotationId);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts to replace those in the current on-call rotation with.
         * </p>
         * <p>
         * If you want to include any current team members in the override shift, you must include their ARNs in the new
         * contact ID list.
         * </p>
         * 
         * @param newContactIds
         *        The Amazon Resource Names (ARNs) of the contacts to replace those in the current on-call rotation
         *        with.</p>
         *        <p>
         *        If you want to include any current team members in the override shift, you must include their ARNs in
         *        the new contact ID list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newContactIds(Collection<String> newContactIds);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts to replace those in the current on-call rotation with.
         * </p>
         * <p>
         * If you want to include any current team members in the override shift, you must include their ARNs in the new
         * contact ID list.
         * </p>
         * 
         * @param newContactIds
         *        The Amazon Resource Names (ARNs) of the contacts to replace those in the current on-call rotation
         *        with.</p>
         *        <p>
         *        If you want to include any current team members in the override shift, you must include their ARNs in
         *        the new contact ID list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newContactIds(String... newContactIds);

        /**
         * <p>
         * The date and time when the override goes into effect.
         * </p>
         * 
         * @param startTime
         *        The date and time when the override goes into effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time when the override ends.
         * </p>
         * 
         * @param endTime
         *        The date and time when the override ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * A token that ensures that the operation is called only once with the specified details.
         * </p>
         * 
         * @param idempotencyToken
         *        A token that ensures that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String rotationId;

        private List<String> newContactIds = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private Instant endTime;

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRotationOverrideRequest model) {
            super(model);
            rotationId(model.rotationId);
            newContactIds(model.newContactIds);
            startTime(model.startTime);
            endTime(model.endTime);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getRotationId() {
            return rotationId;
        }

        public final void setRotationId(String rotationId) {
            this.rotationId = rotationId;
        }

        @Override
        public final Builder rotationId(String rotationId) {
            this.rotationId = rotationId;
            return this;
        }

        public final Collection<String> getNewContactIds() {
            if (newContactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return newContactIds;
        }

        public final void setNewContactIds(Collection<String> newContactIds) {
            this.newContactIds = RotationOverrideContactsArnListCopier.copy(newContactIds);
        }

        @Override
        public final Builder newContactIds(Collection<String> newContactIds) {
            this.newContactIds = RotationOverrideContactsArnListCopier.copy(newContactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newContactIds(String... newContactIds) {
            newContactIds(Arrays.asList(newContactIds));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRotationOverrideRequest build() {
            return new CreateRotationOverrideRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
