/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.RecurrenceSettings;
import software.amazon.awssdk.services.ssmcontacts.model.RotationContactsArnListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.Tag;
import software.amazon.awssdk.services.ssmcontacts.model.TagsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRotationRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, CreateRotationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateRotationRequest.getter(CreateRotationRequest::name)).setter(CreateRotationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> CONTACT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactIds").getter(CreateRotationRequest.getter(CreateRotationRequest::contactIds)).setter(CreateRotationRequest.setter(Builder::contactIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CreateRotationRequest.getter(CreateRotationRequest::startTime)).setter(CreateRotationRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZoneId").getter(CreateRotationRequest.getter(CreateRotationRequest::timeZoneId)).setter(CreateRotationRequest.setter(Builder::timeZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()}).build();
    private static final SdkField<RecurrenceSettings> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(CreateRotationRequest.getter(CreateRotationRequest::recurrence)).setter(CreateRotationRequest.setter(Builder::recurrence)).constructor(RecurrenceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRotationRequest.getter(CreateRotationRequest::tags)).setter(CreateRotationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateRotationRequest.getter(CreateRotationRequest::idempotencyToken)).setter(CreateRotationRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTACT_IDS_FIELD, START_TIME_FIELD, TIME_ZONE_ID_FIELD, RECURRENCE_FIELD, TAGS_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRotationRequest.memberNameToFieldInitializer();
    private final String name;
    private final List<String> contactIds;
    private final Instant startTime;
    private final String timeZoneId;
    private final RecurrenceSettings recurrence;
    private final List<Tag> tags;
    private final String idempotencyToken;

    private CreateRotationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.contactIds = builder.contactIds;
        this.startTime = builder.startTime;
        this.timeZoneId = builder.timeZoneId;
        this.recurrence = builder.recurrence;
        this.tags = builder.tags;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasContactIds() {
        return this.contactIds != null && !(this.contactIds instanceof SdkAutoConstructList);
    }

    public final List<String> contactIds() {
        return this.contactIds;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String timeZoneId() {
        return this.timeZoneId;
    }

    public final RecurrenceSettings recurrence() {
        return this.recurrence;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactIds() ? this.contactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRotationRequest)) {
            return false;
        }
        CreateRotationRequest other = (CreateRotationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasContactIds() == other.hasContactIds() && Objects.equals(this.contactIds(), other.contactIds()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.recurrence(), other.recurrence()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRotationRequest").add("Name", (Object)this.name()).add("ContactIds", this.hasContactIds() ? this.contactIds() : null).add("StartTime", (Object)this.startTime()).add("TimeZoneId", (Object)this.timeZoneId()).add("Recurrence", (Object)this.recurrence()).add("Tags", this.hasTags() ? this.tags() : null).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ContactIds": {
                return Optional.ofNullable(clazz.cast(this.contactIds()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "TimeZoneId": {
                return Optional.ofNullable(clazz.cast(this.timeZoneId()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("ContactIds", CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("TimeZoneId", TIME_ZONE_ID_FIELD);
        map.put("Recurrence", RECURRENCE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRotationRequest, T> g) {
        return obj -> g.apply((CreateRotationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<String> contactIds = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private String timeZoneId;
        private RecurrenceSettings recurrence;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRotationRequest model) {
            super(model);
            this.name(model.name);
            this.contactIds(model.contactIds);
            this.startTime(model.startTime);
            this.timeZoneId(model.timeZoneId);
            this.recurrence(model.recurrence);
            this.tags(model.tags);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getContactIds() {
            if (this.contactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contactIds;
        }

        public final void setContactIds(Collection<String> contactIds) {
            this.contactIds = RotationContactsArnListCopier.copy(contactIds);
        }

        @Override
        public final Builder contactIds(Collection<String> contactIds) {
            this.contactIds = RotationContactsArnListCopier.copy(contactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactIds(String ... contactIds) {
            this.contactIds(Arrays.asList(contactIds));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final RecurrenceSettings.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        public final void setRecurrence(RecurrenceSettings.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(RecurrenceSettings recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRotationRequest build() {
            return new CreateRotationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRotationRequest> {
        public Builder name(String var1);

        public Builder contactIds(Collection<String> var1);

        public Builder contactIds(String ... var1);

        public Builder startTime(Instant var1);

        public Builder timeZoneId(String var1);

        public Builder recurrence(RecurrenceSettings var1);

        default public Builder recurrence(Consumer<RecurrenceSettings.Builder> recurrence) {
            return this.recurrence((RecurrenceSettings)((RecurrenceSettings.Builder)RecurrenceSettings.builder().applyMutation(recurrence)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

