/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ssmcontacts.DefaultSsmContactsBaseClientBuilder;
import software.amazon.awssdk.services.ssmcontacts.DefaultSsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClientBuilder;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsServiceClientConfiguration;
import software.amazon.awssdk.services.ssmcontacts.endpoints.SsmContactsEndpointProvider;

@SdkInternalApi
final class DefaultSsmContactsClientBuilder
extends DefaultSsmContactsBaseClientBuilder<SsmContactsClientBuilder, SsmContactsClient>
implements SsmContactsClientBuilder {
    DefaultSsmContactsClientBuilder() {
    }

    @Override
    public DefaultSsmContactsClientBuilder endpointProvider(SsmContactsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SsmContactsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSsmContactsClientBuilder.validateClientOptions(clientConfiguration);
        SsmContactsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSsmContactsClient client = new DefaultSsmContactsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SsmContactsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SsmContactsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

