/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about when an on-call shift begins and ends.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageTime implements SdkPojo, Serializable, ToCopyableBuilder<CoverageTime.Builder, CoverageTime> {
    private static final SdkField<HandOffTime> START_FIELD = SdkField.<HandOffTime> builder(MarshallingType.SDK_POJO)
            .memberName("Start").getter(getter(CoverageTime::start)).setter(setter(Builder::start))
            .constructor(HandOffTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<HandOffTime> END_FIELD = SdkField.<HandOffTime> builder(MarshallingType.SDK_POJO)
            .memberName("End").getter(getter(CoverageTime::end)).setter(setter(Builder::end)).constructor(HandOffTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD));

    private static final long serialVersionUID = 1L;

    private final HandOffTime start;

    private final HandOffTime end;

    private CoverageTime(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * Information about when the on-call rotation shift begins.
     * </p>
     * 
     * @return Information about when the on-call rotation shift begins.
     */
    public final HandOffTime start() {
        return start;
    }

    /**
     * <p>
     * Information about when the on-call rotation shift ends.
     * </p>
     * 
     * @return Information about when the on-call rotation shift ends.
     */
    public final HandOffTime end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageTime)) {
            return false;
        }
        CoverageTime other = (CoverageTime) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CoverageTime").add("Start", start()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageTime, T> g) {
        return obj -> g.apply((CoverageTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageTime> {
        /**
         * <p>
         * Information about when the on-call rotation shift begins.
         * </p>
         * 
         * @param start
         *        Information about when the on-call rotation shift begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(HandOffTime start);

        /**
         * <p>
         * Information about when the on-call rotation shift begins.
         * </p>
         * This is a convenience method that creates an instance of the {@link HandOffTime.Builder} avoiding the need to
         * create one manually via {@link HandOffTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HandOffTime.Builder#build()} is called immediately and its result
         * is passed to {@link #start(HandOffTime)}.
         * 
         * @param start
         *        a consumer that will call methods on {@link HandOffTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #start(HandOffTime)
         */
        default Builder start(Consumer<HandOffTime.Builder> start) {
            return start(HandOffTime.builder().applyMutation(start).build());
        }

        /**
         * <p>
         * Information about when the on-call rotation shift ends.
         * </p>
         * 
         * @param end
         *        Information about when the on-call rotation shift ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(HandOffTime end);

        /**
         * <p>
         * Information about when the on-call rotation shift ends.
         * </p>
         * This is a convenience method that creates an instance of the {@link HandOffTime.Builder} avoiding the need to
         * create one manually via {@link HandOffTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HandOffTime.Builder#build()} is called immediately and its result
         * is passed to {@link #end(HandOffTime)}.
         * 
         * @param end
         *        a consumer that will call methods on {@link HandOffTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #end(HandOffTime)
         */
        default Builder end(Consumer<HandOffTime.Builder> end) {
            return end(HandOffTime.builder().applyMutation(end).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private HandOffTime start;

        private HandOffTime end;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageTime model) {
            start(model.start);
            end(model.end);
        }

        public final HandOffTime.Builder getStart() {
            return start != null ? start.toBuilder() : null;
        }

        public final void setStart(HandOffTime.BuilderImpl start) {
            this.start = start != null ? start.build() : null;
        }

        @Override
        public final Builder start(HandOffTime start) {
            this.start = start;
            return this;
        }

        public final HandOffTime.Builder getEnd() {
            return end != null ? end.toBuilder() : null;
        }

        public final void setEnd(HandOffTime.BuilderImpl end) {
            this.end = end != null ? end.build() : null;
        }

        @Override
        public final Builder end(HandOffTime end) {
            this.end = end;
            return this;
        }

        @Override
        public CoverageTime build() {
            return new CoverageTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
