/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.Rotation;

public class ListRotationsIterable
implements SdkIterable<ListRotationsResponse> {
    private final SsmContactsClient client;
    private final ListRotationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRotationsIterable(SsmContactsClient client, ListRotationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRotationsResponseFetcher();
    }

    public Iterator<ListRotationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Rotation> rotations() {
        Function<ListRotationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotations() != null) {
                return response.rotations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRotationsResponseFetcher
    implements SyncPageFetcher<ListRotationsResponse> {
        private ListRotationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRotationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRotationsResponse nextPage(ListRotationsResponse previousPage) {
            if (previousPage == null) {
                return ListRotationsIterable.this.client.listRotations(ListRotationsIterable.this.firstRequest);
            }
            return ListRotationsIterable.this.client.listRotations((ListRotationsRequest)((Object)ListRotationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

