/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DependentEntity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DependentEntity> {
    private static final SdkField<String> RELATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelationType").getter(DependentEntity.getter(DependentEntity::relationType)).setter(DependentEntity.setter(Builder::relationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationType").build()}).build();
    private static final SdkField<List<String>> DEPENDENT_RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DependentResourceIds").getter(DependentEntity.getter(DependentEntity::dependentResourceIds)).setter(DependentEntity.setter(Builder::dependentResourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DependentResourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATION_TYPE_FIELD, DEPENDENT_RESOURCE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String relationType;
    private final List<String> dependentResourceIds;

    private DependentEntity(BuilderImpl builder) {
        this.relationType = builder.relationType;
        this.dependentResourceIds = builder.dependentResourceIds;
    }

    public final String relationType() {
        return this.relationType;
    }

    public final boolean hasDependentResourceIds() {
        return this.dependentResourceIds != null && !(this.dependentResourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> dependentResourceIds() {
        return this.dependentResourceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependentResourceIds() ? this.dependentResourceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependentEntity)) {
            return false;
        }
        DependentEntity other = (DependentEntity)obj;
        return Objects.equals(this.relationType(), other.relationType()) && this.hasDependentResourceIds() == other.hasDependentResourceIds() && Objects.equals(this.dependentResourceIds(), other.dependentResourceIds());
    }

    public final String toString() {
        return ToString.builder((String)"DependentEntity").add("RelationType", (Object)this.relationType()).add("DependentResourceIds", this.hasDependentResourceIds() ? this.dependentResourceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RelationType": {
                return Optional.ofNullable(clazz.cast(this.relationType()));
            }
            case "DependentResourceIds": {
                return Optional.ofNullable(clazz.cast(this.dependentResourceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DependentEntity, T> g) {
        return obj -> g.apply((DependentEntity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String relationType;
        private List<String> dependentResourceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DependentEntity model) {
            this.relationType(model.relationType);
            this.dependentResourceIds(model.dependentResourceIds);
        }

        public final String getRelationType() {
            return this.relationType;
        }

        public final void setRelationType(String relationType) {
            this.relationType = relationType;
        }

        @Override
        public final Builder relationType(String relationType) {
            this.relationType = relationType;
            return this;
        }

        public final Collection<String> getDependentResourceIds() {
            if (this.dependentResourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dependentResourceIds;
        }

        public final void setDependentResourceIds(Collection<String> dependentResourceIds) {
            this.dependentResourceIds = SsmContactsArnListCopier.copy(dependentResourceIds);
        }

        @Override
        public final Builder dependentResourceIds(Collection<String> dependentResourceIds) {
            this.dependentResourceIds = SsmContactsArnListCopier.copy(dependentResourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependentResourceIds(String ... dependentResourceIds) {
            this.dependentResourceIds(Arrays.asList(dependentResourceIds));
            return this;
        }

        public DependentEntity build() {
            return new DependentEntity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DependentEntity> {
        public Builder relationType(String var1);

        public Builder dependentResourceIds(Collection<String> var1);

        public Builder dependentResourceIds(String ... var1);
    }
}

