/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.Receipt;

public class ListPageReceiptsPublisher
implements SdkPublisher<ListPageReceiptsResponse> {
    private final SsmContactsAsyncClient client;
    private final ListPageReceiptsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPageReceiptsPublisher(SsmContactsAsyncClient client, ListPageReceiptsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPageReceiptsPublisher(SsmContactsAsyncClient client, ListPageReceiptsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPageReceiptsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPageReceiptsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Receipt> receipts() {
        Function<ListPageReceiptsResponse, Iterator> getIterator = response -> {
            if (response != null && response.receipts() != null) {
                return response.receipts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPageReceiptsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPageReceiptsResponseFetcher
    implements AsyncPageFetcher<ListPageReceiptsResponse> {
        private ListPageReceiptsResponseFetcher() {
        }

        public boolean hasNextPage(ListPageReceiptsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPageReceiptsResponse> nextPage(ListPageReceiptsResponse previousPage) {
            if (previousPage == null) {
                return ListPageReceiptsPublisher.this.client.listPageReceipts(ListPageReceiptsPublisher.this.firstRequest);
            }
            return ListPageReceiptsPublisher.this.client.listPageReceipts((ListPageReceiptsRequest)((Object)ListPageReceiptsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

