/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ReceiptType {
    DELIVERED("DELIVERED"),
    ERROR("ERROR"),
    READ("READ"),
    SENT("SENT"),
    STOP("STOP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ReceiptType> VALUE_MAP;
    private final String value;

    private ReceiptType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReceiptType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReceiptType> knownValues() {
        EnumSet<ReceiptType> knownValues = EnumSet.allOf(ReceiptType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ReceiptType.class, ReceiptType::toString);
    }
}

