/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Engagement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Engagement> {
    private static final SdkField<String> ENGAGEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngagementArn").getter(Engagement.getter(Engagement::engagementArn)).setter(Engagement.setter(Builder::engagementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementArn").build()}).build();
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(Engagement.getter(Engagement::contactArn)).setter(Engagement.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> SENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Sender").getter(Engagement.getter(Engagement::sender)).setter(Engagement.setter(Builder::sender)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()}).build();
    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncidentId").getter(Engagement.getter(Engagement::incidentId)).setter(Engagement.setter(Builder::incidentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Engagement.getter(Engagement::startTime)).setter(Engagement.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StopTime").getter(Engagement.getter(Engagement::stopTime)).setter(Engagement.setter(Builder::stopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGAGEMENT_ARN_FIELD, CONTACT_ARN_FIELD, SENDER_FIELD, INCIDENT_ID_FIELD, START_TIME_FIELD, STOP_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String engagementArn;
    private final String contactArn;
    private final String sender;
    private final String incidentId;
    private final Instant startTime;
    private final Instant stopTime;

    private Engagement(BuilderImpl builder) {
        this.engagementArn = builder.engagementArn;
        this.contactArn = builder.contactArn;
        this.sender = builder.sender;
        this.incidentId = builder.incidentId;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
    }

    public final String engagementArn() {
        return this.engagementArn;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final String sender() {
        return this.sender;
    }

    public final String incidentId() {
        return this.incidentId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant stopTime() {
        return this.stopTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sender());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Engagement)) {
            return false;
        }
        Engagement other = (Engagement)obj;
        return Objects.equals(this.engagementArn(), other.engagementArn()) && Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.sender(), other.sender()) && Objects.equals(this.incidentId(), other.incidentId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stopTime(), other.stopTime());
    }

    public final String toString() {
        return ToString.builder((String)"Engagement").add("EngagementArn", (Object)this.engagementArn()).add("ContactArn", (Object)this.contactArn()).add("Sender", (Object)this.sender()).add("IncidentId", (Object)this.incidentId()).add("StartTime", (Object)this.startTime()).add("StopTime", (Object)this.stopTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngagementArn": {
                return Optional.ofNullable(clazz.cast(this.engagementArn()));
            }
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "Sender": {
                return Optional.ofNullable(clazz.cast(this.sender()));
            }
            case "IncidentId": {
                return Optional.ofNullable(clazz.cast(this.incidentId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "StopTime": {
                return Optional.ofNullable(clazz.cast(this.stopTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Engagement, T> g) {
        return obj -> g.apply((Engagement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String engagementArn;
        private String contactArn;
        private String sender;
        private String incidentId;
        private Instant startTime;
        private Instant stopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Engagement model) {
            this.engagementArn(model.engagementArn);
            this.contactArn(model.contactArn);
            this.sender(model.sender);
            this.incidentId(model.incidentId);
            this.startTime(model.startTime);
            this.stopTime(model.stopTime);
        }

        public final String getEngagementArn() {
            return this.engagementArn;
        }

        @Override
        public final Builder engagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
            return this;
        }

        public final void setEngagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getSender() {
            return this.sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        public final String getIncidentId() {
            return this.incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getStopTime() {
            return this.stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        public Engagement build() {
            return new Engagement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Engagement> {
        public Builder engagementArn(String var1);

        public Builder contactArn(String var1);

        public Builder sender(String var1);

        public Builder incidentId(String var1);

        public Builder startTime(Instant var1);

        public Builder stopTime(Instant var1);
    }
}

