/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.ActivationStatus;
import software.amazon.awssdk.services.ssmcontacts.model.ChannelType;
import software.amazon.awssdk.services.ssmcontacts.model.ContactChannelAddress;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetContactChannelResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, GetContactChannelResponse> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(GetContactChannelResponse.getter(GetContactChannelResponse::contactArn)).setter(GetContactChannelResponse.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> CONTACT_CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactChannelArn").getter(GetContactChannelResponse.getter(GetContactChannelResponse::contactChannelArn)).setter(GetContactChannelResponse.setter(Builder::contactChannelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetContactChannelResponse.getter(GetContactChannelResponse::name)).setter(GetContactChannelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetContactChannelResponse.getter(GetContactChannelResponse::typeAsString)).setter(GetContactChannelResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<ContactChannelAddress> DELIVERY_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryAddress").getter(GetContactChannelResponse.getter(GetContactChannelResponse::deliveryAddress)).setter(GetContactChannelResponse.setter(Builder::deliveryAddress)).constructor(ContactChannelAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryAddress").build()}).build();
    private static final SdkField<String> ACTIVATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationStatus").getter(GetContactChannelResponse.getter(GetContactChannelResponse::activationStatusAsString)).setter(GetContactChannelResponse.setter(Builder::activationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, CONTACT_CHANNEL_ARN_FIELD, NAME_FIELD, TYPE_FIELD, DELIVERY_ADDRESS_FIELD, ACTIVATION_STATUS_FIELD));
    private final String contactArn;
    private final String contactChannelArn;
    private final String name;
    private final String type;
    private final ContactChannelAddress deliveryAddress;
    private final String activationStatus;

    private GetContactChannelResponse(BuilderImpl builder) {
        super(builder);
        this.contactArn = builder.contactArn;
        this.contactChannelArn = builder.contactChannelArn;
        this.name = builder.name;
        this.type = builder.type;
        this.deliveryAddress = builder.deliveryAddress;
        this.activationStatus = builder.activationStatus;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final String contactChannelArn() {
        return this.contactChannelArn;
    }

    public final String name() {
        return this.name;
    }

    public final ChannelType type() {
        return ChannelType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ContactChannelAddress deliveryAddress() {
        return this.deliveryAddress;
    }

    public final ActivationStatus activationStatus() {
        return ActivationStatus.fromValue(this.activationStatus);
    }

    public final String activationStatusAsString() {
        return this.activationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactChannelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactChannelResponse)) {
            return false;
        }
        GetContactChannelResponse other = (GetContactChannelResponse)((Object)obj);
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.contactChannelArn(), other.contactChannelArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.deliveryAddress(), other.deliveryAddress()) && Objects.equals(this.activationStatusAsString(), other.activationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetContactChannelResponse").add("ContactArn", (Object)this.contactArn()).add("ContactChannelArn", (Object)this.contactChannelArn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("DeliveryAddress", (Object)this.deliveryAddress()).add("ActivationStatus", (Object)this.activationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "ContactChannelArn": {
                return Optional.ofNullable(clazz.cast(this.contactChannelArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "DeliveryAddress": {
                return Optional.ofNullable(clazz.cast(this.deliveryAddress()));
            }
            case "ActivationStatus": {
                return Optional.ofNullable(clazz.cast(this.activationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetContactChannelResponse, T> g) {
        return obj -> g.apply((GetContactChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String contactArn;
        private String contactChannelArn;
        private String name;
        private String type;
        private ContactChannelAddress deliveryAddress;
        private String activationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactChannelResponse model) {
            super(model);
            this.contactArn(model.contactArn);
            this.contactChannelArn(model.contactChannelArn);
            this.name(model.name);
            this.type(model.type);
            this.deliveryAddress(model.deliveryAddress);
            this.activationStatus(model.activationStatus);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        public final String getContactChannelArn() {
            return this.contactChannelArn;
        }

        @Override
        public final Builder contactChannelArn(String contactChannelArn) {
            this.contactChannelArn = contactChannelArn;
            return this;
        }

        public final void setContactChannelArn(String contactChannelArn) {
            this.contactChannelArn = contactChannelArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ChannelType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final ContactChannelAddress.Builder getDeliveryAddress() {
            return this.deliveryAddress != null ? this.deliveryAddress.toBuilder() : null;
        }

        @Override
        public final Builder deliveryAddress(ContactChannelAddress deliveryAddress) {
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        public final void setDeliveryAddress(ContactChannelAddress.BuilderImpl deliveryAddress) {
            this.deliveryAddress = deliveryAddress != null ? deliveryAddress.build() : null;
        }

        public final String getActivationStatus() {
            return this.activationStatus;
        }

        @Override
        public final Builder activationStatus(String activationStatus) {
            this.activationStatus = activationStatus;
            return this;
        }

        @Override
        public final Builder activationStatus(ActivationStatus activationStatus) {
            this.activationStatus(activationStatus == null ? null : activationStatus.toString());
            return this;
        }

        public final void setActivationStatus(String activationStatus) {
            this.activationStatus = activationStatus;
        }

        @Override
        public GetContactChannelResponse build() {
            return new GetContactChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetContactChannelResponse> {
        public Builder contactArn(String var1);

        public Builder contactChannelArn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ChannelType var1);

        public Builder deliveryAddress(ContactChannelAddress var1);

        default public Builder deliveryAddress(Consumer<ContactChannelAddress.Builder> deliveryAddress) {
            return this.deliveryAddress((ContactChannelAddress)((ContactChannelAddress.Builder)ContactChannelAddress.builder().applyMutation(deliveryAddress)).build());
        }

        public Builder activationStatus(String var1);

        public Builder activationStatus(ActivationStatus var1);
    }
}

