/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivateContactChannelRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, ActivateContactChannelRequest> {
    private static final SdkField<String> CONTACT_CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactChannelId").getter(ActivateContactChannelRequest.getter(ActivateContactChannelRequest::contactChannelId)).setter(ActivateContactChannelRequest.setter(Builder::contactChannelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactChannelId").build()}).build();
    private static final SdkField<String> ACTIVATION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivationCode").getter(ActivateContactChannelRequest.getter(ActivateContactChannelRequest::activationCode)).setter(ActivateContactChannelRequest.setter(Builder::activationCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_CHANNEL_ID_FIELD, ACTIVATION_CODE_FIELD));
    private final String contactChannelId;
    private final String activationCode;

    private ActivateContactChannelRequest(BuilderImpl builder) {
        super(builder);
        this.contactChannelId = builder.contactChannelId;
        this.activationCode = builder.activationCode;
    }

    public final String contactChannelId() {
        return this.contactChannelId;
    }

    public final String activationCode() {
        return this.activationCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contactChannelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.activationCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateContactChannelRequest)) {
            return false;
        }
        ActivateContactChannelRequest other = (ActivateContactChannelRequest)((Object)obj);
        return Objects.equals(this.contactChannelId(), other.contactChannelId()) && Objects.equals(this.activationCode(), other.activationCode());
    }

    public final String toString() {
        return ToString.builder((String)"ActivateContactChannelRequest").add("ContactChannelId", (Object)this.contactChannelId()).add("ActivationCode", (Object)this.activationCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactChannelId": {
                return Optional.ofNullable(clazz.cast(this.contactChannelId()));
            }
            case "ActivationCode": {
                return Optional.ofNullable(clazz.cast(this.activationCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActivateContactChannelRequest, T> g) {
        return obj -> g.apply((ActivateContactChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String contactChannelId;
        private String activationCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateContactChannelRequest model) {
            super(model);
            this.contactChannelId(model.contactChannelId);
            this.activationCode(model.activationCode);
        }

        public final String getContactChannelId() {
            return this.contactChannelId;
        }

        @Override
        public final Builder contactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
            return this;
        }

        public final void setContactChannelId(String contactChannelId) {
            this.contactChannelId = contactChannelId;
        }

        public final String getActivationCode() {
            return this.activationCode;
        }

        @Override
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateContactChannelRequest build() {
            return new ActivateContactChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ActivateContactChannelRequest> {
        public Builder contactChannelId(String var1);

        public Builder activationCode(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

