/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.LoggingInfo;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskInvocationParameters;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParameterValueExpression;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTaskParametersCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMaintenanceWindowTaskRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, UpdateMaintenanceWindowTaskRequest> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::windowId)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> WINDOW_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::windowTaskId)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::windowTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTaskId").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::targets)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::taskArn)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::serviceRoleArn)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<Map<String, MaintenanceWindowTaskParameterValueExpression>> TASK_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::taskParameters)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::taskParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MaintenanceWindowTaskParameterValueExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<MaintenanceWindowTaskInvocationParameters> TASK_INVOCATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::taskInvocationParameters)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::taskInvocationParameters)).constructor(MaintenanceWindowTaskInvocationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInvocationParameters").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::priority)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::maxConcurrency)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::maxErrors)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::loggingInfo)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingInfo").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::name)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::description)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> REPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateMaintenanceWindowTaskRequest.getter(UpdateMaintenanceWindowTaskRequest::replace)).setter(UpdateMaintenanceWindowTaskRequest.setter(Builder::replace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, WINDOW_TASK_ID_FIELD, TARGETS_FIELD, TASK_ARN_FIELD, SERVICE_ROLE_ARN_FIELD, TASK_PARAMETERS_FIELD, TASK_INVOCATION_PARAMETERS_FIELD, PRIORITY_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, LOGGING_INFO_FIELD, NAME_FIELD, DESCRIPTION_FIELD, REPLACE_FIELD));
    private final String windowId;
    private final String windowTaskId;
    private final List<Target> targets;
    private final String taskArn;
    private final String serviceRoleArn;
    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;
    private final MaintenanceWindowTaskInvocationParameters taskInvocationParameters;
    private final Integer priority;
    private final String maxConcurrency;
    private final String maxErrors;
    private final LoggingInfo loggingInfo;
    private final String name;
    private final String description;
    private final Boolean replace;

    private UpdateMaintenanceWindowTaskRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.taskParameters = builder.taskParameters;
        this.taskInvocationParameters = builder.taskInvocationParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.loggingInfo = builder.loggingInfo;
        this.name = builder.name;
        this.description = builder.description;
        this.replace = builder.replace;
    }

    public String windowId() {
        return this.windowId;
    }

    public String windowTaskId() {
        return this.windowTaskId;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String taskArn() {
        return this.taskArn;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return this.taskParameters;
    }

    public MaintenanceWindowTaskInvocationParameters taskInvocationParameters() {
        return this.taskInvocationParameters;
    }

    public Integer priority() {
        return this.priority;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Boolean replace() {
        return this.replace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskInvocationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.replace());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMaintenanceWindowTaskRequest)) {
            return false;
        }
        UpdateMaintenanceWindowTaskRequest other = (UpdateMaintenanceWindowTaskRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowTaskId(), other.windowTaskId()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.taskParameters(), other.taskParameters()) && Objects.equals(this.taskInvocationParameters(), other.taskInvocationParameters()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.replace(), other.replace());
    }

    public String toString() {
        return ToString.builder((String)"UpdateMaintenanceWindowTaskRequest").add("WindowId", (Object)this.windowId()).add("WindowTaskId", (Object)this.windowTaskId()).add("Targets", this.targets()).add("TaskArn", (Object)this.taskArn()).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("TaskParameters", (Object)(this.taskParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("TaskInvocationParameters", (Object)this.taskInvocationParameters()).add("Priority", (Object)this.priority()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("LoggingInfo", (Object)this.loggingInfo()).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Replace", (Object)this.replace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "WindowTaskId": {
                return Optional.ofNullable(clazz.cast(this.windowTaskId()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TaskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "TaskParameters": {
                return Optional.ofNullable(clazz.cast(this.taskParameters()));
            }
            case "TaskInvocationParameters": {
                return Optional.ofNullable(clazz.cast(this.taskInvocationParameters()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Replace": {
                return Optional.ofNullable(clazz.cast(this.replace()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMaintenanceWindowTaskRequest, T> g) {
        return obj -> g.apply((UpdateMaintenanceWindowTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private String windowTaskId;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String taskArn;
        private String serviceRoleArn;
        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters = DefaultSdkAutoConstructMap.getInstance();
        private MaintenanceWindowTaskInvocationParameters taskInvocationParameters;
        private Integer priority;
        private String maxConcurrency;
        private String maxErrors;
        private LoggingInfo loggingInfo;
        private String name;
        private String description;
        private Boolean replace;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMaintenanceWindowTaskRequest model) {
            super(model);
            this.windowId(model.windowId);
            this.windowTaskId(model.windowTaskId);
            this.targets(model.targets);
            this.taskArn(model.taskArn);
            this.serviceRoleArn(model.serviceRoleArn);
            this.taskParameters(model.taskParameters);
            this.taskInvocationParameters(model.taskInvocationParameters);
            this.priority(model.priority);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.loggingInfo(model.loggingInfo);
            this.name(model.name);
            this.description(model.description);
            this.replace(model.replace);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return this.windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> getTaskParameters() {
            return this.taskParameters != null ? CollectionUtils.mapValues(this.taskParameters, MaintenanceWindowTaskParameterValueExpression::toBuilder) : null;
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression.BuilderImpl> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copyFromBuilder(taskParameters);
        }

        public final MaintenanceWindowTaskInvocationParameters.Builder getTaskInvocationParameters() {
            return this.taskInvocationParameters != null ? this.taskInvocationParameters.toBuilder() : null;
        }

        @Override
        public final Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public final void setTaskInvocationParameters(MaintenanceWindowTaskInvocationParameters.BuilderImpl taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters != null ? taskInvocationParameters.build() : null;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getReplace() {
            return this.replace;
        }

        @Override
        public final Builder replace(Boolean replace) {
            this.replace = replace;
            return this;
        }

        public final void setReplace(Boolean replace) {
            this.replace = replace;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMaintenanceWindowTaskRequest build() {
            return new UpdateMaintenanceWindowTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMaintenanceWindowTaskRequest> {
        public Builder windowId(String var1);

        public Builder windowTaskId(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder taskArn(String var1);

        public Builder serviceRoleArn(String var1);

        public Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> var1);

        public Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters var1);

        default public Builder taskInvocationParameters(Consumer<MaintenanceWindowTaskInvocationParameters.Builder> taskInvocationParameters) {
            return this.taskInvocationParameters((MaintenanceWindowTaskInvocationParameters)((MaintenanceWindowTaskInvocationParameters.Builder)MaintenanceWindowTaskInvocationParameters.builder().applyMutation(taskInvocationParameters)).build());
        }

        public Builder priority(Integer var1);

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder replace(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

