/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterLabelListCopier;
import software.amazon.awssdk.services.ssm.model.SsmResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelParameterVersionResponse
extends SsmResponse
implements ToCopyableBuilder<Builder, LabelParameterVersionResponse> {
    private static final SdkField<List<String>> INVALID_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(LabelParameterVersionResponse.getter(LabelParameterVersionResponse::invalidLabels)).setter(LabelParameterVersionResponse.setter(Builder::invalidLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> PARAMETER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(LabelParameterVersionResponse.getter(LabelParameterVersionResponse::parameterVersion)).setter(LabelParameterVersionResponse.setter(Builder::parameterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_LABELS_FIELD, PARAMETER_VERSION_FIELD));
    private final List<String> invalidLabels;
    private final Long parameterVersion;

    private LabelParameterVersionResponse(BuilderImpl builder) {
        super(builder);
        this.invalidLabels = builder.invalidLabels;
        this.parameterVersion = builder.parameterVersion;
    }

    public List<String> invalidLabels() {
        return this.invalidLabels;
    }

    public Long parameterVersion() {
        return this.parameterVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.invalidLabels());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelParameterVersionResponse)) {
            return false;
        }
        LabelParameterVersionResponse other = (LabelParameterVersionResponse)((Object)obj);
        return Objects.equals(this.invalidLabels(), other.invalidLabels()) && Objects.equals(this.parameterVersion(), other.parameterVersion());
    }

    public String toString() {
        return ToString.builder((String)"LabelParameterVersionResponse").add("InvalidLabels", this.invalidLabels()).add("ParameterVersion", (Object)this.parameterVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InvalidLabels": {
                return Optional.ofNullable(clazz.cast(this.invalidLabels()));
            }
            case "ParameterVersion": {
                return Optional.ofNullable(clazz.cast(this.parameterVersion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelParameterVersionResponse, T> g) {
        return obj -> g.apply((LabelParameterVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmResponse.BuilderImpl
    implements Builder {
        private List<String> invalidLabels = DefaultSdkAutoConstructList.getInstance();
        private Long parameterVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelParameterVersionResponse model) {
            super(model);
            this.invalidLabels(model.invalidLabels);
            this.parameterVersion(model.parameterVersion);
        }

        public final Collection<String> getInvalidLabels() {
            return this.invalidLabels;
        }

        @Override
        public final Builder invalidLabels(Collection<String> invalidLabels) {
            this.invalidLabels = ParameterLabelListCopier.copy(invalidLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidLabels(String ... invalidLabels) {
            this.invalidLabels(Arrays.asList(invalidLabels));
            return this;
        }

        public final void setInvalidLabels(Collection<String> invalidLabels) {
            this.invalidLabels = ParameterLabelListCopier.copy(invalidLabels);
        }

        public final Long getParameterVersion() {
            return this.parameterVersion;
        }

        @Override
        public final Builder parameterVersion(Long parameterVersion) {
            this.parameterVersion = parameterVersion;
            return this;
        }

        public final void setParameterVersion(Long parameterVersion) {
            this.parameterVersion = parameterVersion;
        }

        @Override
        public LabelParameterVersionResponse build() {
            return new LabelParameterVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, LabelParameterVersionResponse> {
        public Builder invalidLabels(Collection<String> var1);

        public Builder invalidLabels(String ... var1);

        public Builder parameterVersion(Long var1);
    }
}

