/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.TargetParameterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolvedTargets
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolvedTargets> {
    private static final SdkField<List<String>> PARAMETER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ResolvedTargets.getter(ResolvedTargets::parameterValues)).setter(ResolvedTargets.setter(Builder::parameterValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ResolvedTargets.getter(ResolvedTargets::truncated)).setter(ResolvedTargets.setter(Builder::truncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truncated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_VALUES_FIELD, TRUNCATED_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> parameterValues;
    private final Boolean truncated;

    private ResolvedTargets(BuilderImpl builder) {
        this.parameterValues = builder.parameterValues;
        this.truncated = builder.truncated;
    }

    public List<String> parameterValues() {
        return this.parameterValues;
    }

    public Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.truncated());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolvedTargets)) {
            return false;
        }
        ResolvedTargets other = (ResolvedTargets)obj;
        return Objects.equals(this.parameterValues(), other.parameterValues()) && Objects.equals(this.truncated(), other.truncated());
    }

    public String toString() {
        return ToString.builder((String)"ResolvedTargets").add("ParameterValues", this.parameterValues()).add("Truncated", (Object)this.truncated()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterValues": {
                return Optional.ofNullable(clazz.cast(this.parameterValues()));
            }
            case "Truncated": {
                return Optional.ofNullable(clazz.cast(this.truncated()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResolvedTargets, T> g) {
        return obj -> g.apply((ResolvedTargets)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> parameterValues = DefaultSdkAutoConstructList.getInstance();
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolvedTargets model) {
            this.parameterValues(model.parameterValues);
            this.truncated(model.truncated);
        }

        public final Collection<String> getParameterValues() {
            return this.parameterValues;
        }

        @Override
        public final Builder parameterValues(Collection<String> parameterValues) {
            this.parameterValues = TargetParameterListCopier.copy(parameterValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterValues(String ... parameterValues) {
            this.parameterValues(Arrays.asList(parameterValues));
            return this;
        }

        public final void setParameterValues(Collection<String> parameterValues) {
            this.parameterValues = TargetParameterListCopier.copy(parameterValues);
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        public ResolvedTargets build() {
            return new ResolvedTargets(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolvedTargets> {
        public Builder parameterValues(Collection<String> var1);

        public Builder parameterValues(String ... var1);

        public Builder truncated(Boolean var1);
    }
}

