/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OpsItemFilter;
import software.amazon.awssdk.services.ssm.model.OpsItemFiltersCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOpsItemsRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DescribeOpsItemsRequest> {
    private static final SdkField<List<OpsItemFilter>> OPS_ITEM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeOpsItemsRequest.getter(DescribeOpsItemsRequest::opsItemFilters)).setter(DescribeOpsItemsRequest.setter(Builder::opsItemFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OpsItemFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeOpsItemsRequest.getter(DescribeOpsItemsRequest::maxResults)).setter(DescribeOpsItemsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeOpsItemsRequest.getter(DescribeOpsItemsRequest::nextToken)).setter(DescribeOpsItemsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<OpsItemFilter> opsItemFilters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeOpsItemsRequest(BuilderImpl builder) {
        super(builder);
        this.opsItemFilters = builder.opsItemFilters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<OpsItemFilter> opsItemFilters() {
        return this.opsItemFilters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.opsItemFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOpsItemsRequest)) {
            return false;
        }
        DescribeOpsItemsRequest other = (DescribeOpsItemsRequest)((Object)obj);
        return Objects.equals(this.opsItemFilters(), other.opsItemFilters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOpsItemsRequest").add("OpsItemFilters", this.opsItemFilters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OpsItemFilters": {
                return Optional.ofNullable(clazz.cast(this.opsItemFilters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOpsItemsRequest, T> g) {
        return obj -> g.apply((DescribeOpsItemsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<OpsItemFilter> opsItemFilters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOpsItemsRequest model) {
            super(model);
            this.opsItemFilters(model.opsItemFilters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<OpsItemFilter.Builder> getOpsItemFilters() {
            return this.opsItemFilters != null ? (Collection)this.opsItemFilters.stream().map(OpsItemFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder opsItemFilters(Collection<OpsItemFilter> opsItemFilters) {
            this.opsItemFilters = OpsItemFiltersCopier.copy(opsItemFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsItemFilters(OpsItemFilter ... opsItemFilters) {
            this.opsItemFilters(Arrays.asList(opsItemFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opsItemFilters(Consumer<OpsItemFilter.Builder> ... opsItemFilters) {
            this.opsItemFilters(Stream.of(opsItemFilters).map(c -> (OpsItemFilter)((OpsItemFilter.Builder)OpsItemFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOpsItemFilters(Collection<OpsItemFilter.BuilderImpl> opsItemFilters) {
            this.opsItemFilters = OpsItemFiltersCopier.copyFromBuilder(opsItemFilters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeOpsItemsRequest build() {
            return new DescribeOpsItemsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOpsItemsRequest> {
        public Builder opsItemFilters(Collection<OpsItemFilter> var1);

        public Builder opsItemFilters(OpsItemFilter ... var1);

        public Builder opsItemFilters(Consumer<OpsItemFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

