/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilter;
import software.amazon.awssdk.services.ssm.model.ParameterStringFilterListCopier;
import software.amazon.awssdk.services.ssm.model.ParametersFilter;
import software.amazon.awssdk.services.ssm.model.ParametersFilterListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeParametersRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, DescribeParametersRequest> {
    private static final SdkField<List<ParametersFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeParametersRequest.getter(DescribeParametersRequest::filters)).setter(DescribeParametersRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParametersFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ParameterStringFilter>> PARAMETER_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeParametersRequest.getter(DescribeParametersRequest::parameterFilters)).setter(DescribeParametersRequest.setter(Builder::parameterFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParameterStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(DescribeParametersRequest.getter(DescribeParametersRequest::maxResults)).setter(DescribeParametersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeParametersRequest.getter(DescribeParametersRequest::nextToken)).setter(DescribeParametersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, PARAMETER_FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ParametersFilter> filters;
    private final List<ParameterStringFilter> parameterFilters;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeParametersRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.parameterFilters = builder.parameterFilters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<ParametersFilter> filters() {
        return this.filters;
    }

    public List<ParameterStringFilter> parameterFilters() {
        return this.parameterFilters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeParametersRequest)) {
            return false;
        }
        DescribeParametersRequest other = (DescribeParametersRequest)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.parameterFilters(), other.parameterFilters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeParametersRequest").add("Filters", this.filters()).add("ParameterFilters", this.parameterFilters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "ParameterFilters": {
                return Optional.ofNullable(clazz.cast(this.parameterFilters()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeParametersRequest, T> g) {
        return obj -> g.apply((DescribeParametersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private List<ParametersFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private List<ParameterStringFilter> parameterFilters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeParametersRequest model) {
            super(model);
            this.filters(model.filters);
            this.parameterFilters(model.parameterFilters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<ParametersFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(ParametersFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ParametersFilter> filters) {
            this.filters = ParametersFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ParametersFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ParametersFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ParametersFilter)((ParametersFilter.Builder)ParametersFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ParametersFilter.BuilderImpl> filters) {
            this.filters = ParametersFilterListCopier.copyFromBuilder(filters);
        }

        public final Collection<ParameterStringFilter.Builder> getParameterFilters() {
            return this.parameterFilters != null ? (Collection)this.parameterFilters.stream().map(ParameterStringFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterFilters(Collection<ParameterStringFilter> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copy(parameterFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(ParameterStringFilter ... parameterFilters) {
            this.parameterFilters(Arrays.asList(parameterFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterFilters(Consumer<ParameterStringFilter.Builder> ... parameterFilters) {
            this.parameterFilters(Stream.of(parameterFilters).map(c -> (ParameterStringFilter)((ParameterStringFilter.Builder)ParameterStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterFilters(Collection<ParameterStringFilter.BuilderImpl> parameterFilters) {
            this.parameterFilters = ParameterStringFilterListCopier.copyFromBuilder(parameterFilters);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeParametersRequest build() {
            return new DescribeParametersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeParametersRequest> {
        public Builder filters(Collection<ParametersFilter> var1);

        public Builder filters(ParametersFilter ... var1);

        public Builder filters(Consumer<ParametersFilter.Builder> ... var1);

        public Builder parameterFilters(Collection<ParameterStringFilter> var1);

        public Builder parameterFilters(ParameterStringFilter ... var1);

        public Builder parameterFilters(Consumer<ParameterStringFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

