/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledWindowExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledWindowExecution> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledWindowExecution.getter(ScheduledWindowExecution::windowId)).setter(ScheduledWindowExecution.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledWindowExecution.getter(ScheduledWindowExecution::name)).setter(ScheduledWindowExecution.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScheduledWindowExecution.getter(ScheduledWindowExecution::executionTime)).setter(ScheduledWindowExecution.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, NAME_FIELD, EXECUTION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String windowId;
    private final String name;
    private final String executionTime;

    private ScheduledWindowExecution(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.name = builder.name;
        this.executionTime = builder.executionTime;
    }

    public String windowId() {
        return this.windowId;
    }

    public String name() {
        return this.name;
    }

    public String executionTime() {
        return this.executionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledWindowExecution)) {
            return false;
        }
        ScheduledWindowExecution other = (ScheduledWindowExecution)obj;
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.executionTime(), other.executionTime());
    }

    public String toString() {
        return ToString.builder((String)"ScheduledWindowExecution").add("WindowId", (Object)this.windowId()).add("Name", (Object)this.name()).add("ExecutionTime", (Object)this.executionTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledWindowExecution, T> g) {
        return obj -> g.apply((ScheduledWindowExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String name;
        private String executionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledWindowExecution model) {
            this.windowId(model.windowId);
            this.name(model.name);
            this.executionTime(model.executionTime);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getExecutionTime() {
            return this.executionTime;
        }

        @Override
        public final Builder executionTime(String executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final void setExecutionTime(String executionTime) {
            this.executionTime = executionTime;
        }

        public ScheduledWindowExecution build() {
            return new ScheduledWindowExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledWindowExecution> {
        public Builder windowId(String var1);

        public Builder name(String var1);

        public Builder executionTime(String var1);
    }
}

