/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.AutomationType;
import software.amazon.awssdk.services.ssm.model.ExecutionMode;
import software.amazon.awssdk.services.ssm.model.ResolvedTargets;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetMapsCopier;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationExecutionMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationExecutionMetadata> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationExecutionId)).setter(AutomationExecutionMetadata.setter(Builder::automationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build()}).build();
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::documentName)).setter(AutomationExecutionMetadata.setter(Builder::documentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::documentVersion)).setter(AutomationExecutionMetadata.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> AUTOMATION_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationExecutionStatusAsString)).setter(AutomationExecutionMetadata.setter(Builder::automationExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionStatus").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executionStartTime)).setter(AutomationExecutionMetadata.setter(Builder::executionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executionEndTime)).setter(AutomationExecutionMetadata.setter(Builder::executionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()}).build();
    private static final SdkField<String> EXECUTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::executedBy)).setter(AutomationExecutionMetadata.setter(Builder::executedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutedBy").build()}).build();
    private static final SdkField<String> LOG_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::logFile)).setter(AutomationExecutionMetadata.setter(Builder::logFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFile").build()}).build();
    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::outputs)).setter(AutomationExecutionMetadata.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::modeAsString)).setter(AutomationExecutionMetadata.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PARENT_AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::parentAutomationExecutionId)).setter(AutomationExecutionMetadata.setter(Builder::parentAutomationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentAutomationExecutionId").build()}).build();
    private static final SdkField<String> CURRENT_STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::currentStepName)).setter(AutomationExecutionMetadata.setter(Builder::currentStepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentStepName").build()}).build();
    private static final SdkField<String> CURRENT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::currentAction)).setter(AutomationExecutionMetadata.setter(Builder::currentAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAction").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::failureMessage)).setter(AutomationExecutionMetadata.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::targetParameterName)).setter(AutomationExecutionMetadata.setter(Builder::targetParameterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::targets)).setter(AutomationExecutionMetadata.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::targetMaps)).setter(AutomationExecutionMetadata.setter(Builder::targetMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<ResolvedTargets> RESOLVED_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::resolvedTargets)).setter(AutomationExecutionMetadata.setter(Builder::resolvedTargets)).constructor(ResolvedTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedTargets").build()}).build();
    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::maxConcurrency)).setter(AutomationExecutionMetadata.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::maxErrors)).setter(AutomationExecutionMetadata.setter(Builder::maxErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::target)).setter(AutomationExecutionMetadata.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<String> AUTOMATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AutomationExecutionMetadata.getter(AutomationExecutionMetadata::automationTypeAsString)).setter(AutomationExecutionMetadata.setter(Builder::automationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, AUTOMATION_EXECUTION_STATUS_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, EXECUTED_BY_FIELD, LOG_FILE_FIELD, OUTPUTS_FIELD, MODE_FIELD, PARENT_AUTOMATION_EXECUTION_ID_FIELD, CURRENT_STEP_NAME_FIELD, CURRENT_ACTION_FIELD, FAILURE_MESSAGE_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD, TARGET_MAPS_FIELD, RESOLVED_TARGETS_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_FIELD, AUTOMATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String automationExecutionId;
    private final String documentName;
    private final String documentVersion;
    private final String automationExecutionStatus;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String executedBy;
    private final String logFile;
    private final Map<String, List<String>> outputs;
    private final String mode;
    private final String parentAutomationExecutionId;
    private final String currentStepName;
    private final String currentAction;
    private final String failureMessage;
    private final String targetParameterName;
    private final List<Target> targets;
    private final List<Map<String, List<String>>> targetMaps;
    private final ResolvedTargets resolvedTargets;
    private final String maxConcurrency;
    private final String maxErrors;
    private final String target;
    private final String automationType;

    private AutomationExecutionMetadata(BuilderImpl builder) {
        this.automationExecutionId = builder.automationExecutionId;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.automationExecutionStatus = builder.automationExecutionStatus;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executedBy = builder.executedBy;
        this.logFile = builder.logFile;
        this.outputs = builder.outputs;
        this.mode = builder.mode;
        this.parentAutomationExecutionId = builder.parentAutomationExecutionId;
        this.currentStepName = builder.currentStepName;
        this.currentAction = builder.currentAction;
        this.failureMessage = builder.failureMessage;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.resolvedTargets = builder.resolvedTargets;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.target = builder.target;
        this.automationType = builder.automationType;
    }

    public String automationExecutionId() {
        return this.automationExecutionId;
    }

    public String documentName() {
        return this.documentName;
    }

    public String documentVersion() {
        return this.documentVersion;
    }

    public AutomationExecutionStatus automationExecutionStatus() {
        return AutomationExecutionStatus.fromValue(this.automationExecutionStatus);
    }

    public String automationExecutionStatusAsString() {
        return this.automationExecutionStatus;
    }

    public Instant executionStartTime() {
        return this.executionStartTime;
    }

    public Instant executionEndTime() {
        return this.executionEndTime;
    }

    public String executedBy() {
        return this.executedBy;
    }

    public String logFile() {
        return this.logFile;
    }

    public Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public ExecutionMode mode() {
        return ExecutionMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public String parentAutomationExecutionId() {
        return this.parentAutomationExecutionId;
    }

    public String currentStepName() {
        return this.currentStepName;
    }

    public String currentAction() {
        return this.currentAction;
    }

    public String failureMessage() {
        return this.failureMessage;
    }

    public String targetParameterName() {
        return this.targetParameterName;
    }

    public List<Target> targets() {
        return this.targets;
    }

    public List<Map<String, List<String>>> targetMaps() {
        return this.targetMaps;
    }

    public ResolvedTargets resolvedTargets() {
        return this.resolvedTargets;
    }

    public String maxConcurrency() {
        return this.maxConcurrency;
    }

    public String maxErrors() {
        return this.maxErrors;
    }

    public String target() {
        return this.target;
    }

    public AutomationType automationType() {
        return AutomationType.fromValue(this.automationType);
    }

    public String automationTypeAsString() {
        return this.automationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentAutomationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentStepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targets());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetMaps());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionMetadata)) {
            return false;
        }
        AutomationExecutionMetadata other = (AutomationExecutionMetadata)obj;
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.documentName(), other.documentName()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.automationExecutionStatusAsString(), other.automationExecutionStatusAsString()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.executedBy(), other.executedBy()) && Objects.equals(this.logFile(), other.logFile()) && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.parentAutomationExecutionId(), other.parentAutomationExecutionId()) && Objects.equals(this.currentStepName(), other.currentStepName()) && Objects.equals(this.currentAction(), other.currentAction()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.targetParameterName(), other.targetParameterName()) && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.targetMaps(), other.targetMaps()) && Objects.equals(this.resolvedTargets(), other.resolvedTargets()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.maxErrors(), other.maxErrors()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.automationTypeAsString(), other.automationTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AutomationExecutionMetadata").add("AutomationExecutionId", (Object)this.automationExecutionId()).add("DocumentName", (Object)this.documentName()).add("DocumentVersion", (Object)this.documentVersion()).add("AutomationExecutionStatus", (Object)this.automationExecutionStatusAsString()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("ExecutedBy", (Object)this.executedBy()).add("LogFile", (Object)this.logFile()).add("Outputs", this.outputs()).add("Mode", (Object)this.modeAsString()).add("ParentAutomationExecutionId", (Object)this.parentAutomationExecutionId()).add("CurrentStepName", (Object)this.currentStepName()).add("CurrentAction", (Object)this.currentAction()).add("FailureMessage", (Object)this.failureMessage()).add("TargetParameterName", (Object)this.targetParameterName()).add("Targets", this.targets()).add("TargetMaps", this.targetMaps()).add("ResolvedTargets", (Object)this.resolvedTargets()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MaxErrors", (Object)this.maxErrors()).add("Target", (Object)this.target()).add("AutomationType", (Object)this.automationTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionId()));
            }
            case "DocumentName": {
                return Optional.ofNullable(clazz.cast(this.documentName()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "AutomationExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionStatusAsString()));
            }
            case "ExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "ExecutedBy": {
                return Optional.ofNullable(clazz.cast(this.executedBy()));
            }
            case "LogFile": {
                return Optional.ofNullable(clazz.cast(this.logFile()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "ParentAutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.parentAutomationExecutionId()));
            }
            case "CurrentStepName": {
                return Optional.ofNullable(clazz.cast(this.currentStepName()));
            }
            case "CurrentAction": {
                return Optional.ofNullable(clazz.cast(this.currentAction()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "TargetParameterName": {
                return Optional.ofNullable(clazz.cast(this.targetParameterName()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetMaps": {
                return Optional.ofNullable(clazz.cast(this.targetMaps()));
            }
            case "ResolvedTargets": {
                return Optional.ofNullable(clazz.cast(this.resolvedTargets()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MaxErrors": {
                return Optional.ofNullable(clazz.cast(this.maxErrors()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "AutomationType": {
                return Optional.ofNullable(clazz.cast(this.automationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionMetadata, T> g) {
        return obj -> g.apply((AutomationExecutionMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String documentName;
        private String documentVersion;
        private String automationExecutionStatus;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String executedBy;
        private String logFile;
        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();
        private String mode;
        private String parentAutomationExecutionId;
        private String currentStepName;
        private String currentAction;
        private String failureMessage;
        private String targetParameterName;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();
        private ResolvedTargets resolvedTargets;
        private String maxConcurrency;
        private String maxErrors;
        private String target;
        private String automationType;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionMetadata model) {
            this.automationExecutionId(model.automationExecutionId);
            this.documentName(model.documentName);
            this.documentVersion(model.documentVersion);
            this.automationExecutionStatus(model.automationExecutionStatus);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.executedBy(model.executedBy);
            this.logFile(model.logFile);
            this.outputs(model.outputs);
            this.mode(model.mode);
            this.parentAutomationExecutionId(model.parentAutomationExecutionId);
            this.currentStepName(model.currentStepName);
            this.currentAction(model.currentAction);
            this.failureMessage(model.failureMessage);
            this.targetParameterName(model.targetParameterName);
            this.targets(model.targets);
            this.targetMaps(model.targetMaps);
            this.resolvedTargets(model.resolvedTargets);
            this.maxConcurrency(model.maxConcurrency);
            this.maxErrors(model.maxErrors);
            this.target(model.target);
            this.automationType(model.automationType);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        public final String getDocumentName() {
            return this.documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAutomationExecutionStatusAsString() {
            return this.automationExecutionStatus;
        }

        @Override
        public final Builder automationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
            return this;
        }

        @Override
        public final Builder automationExecutionStatus(AutomationExecutionStatus automationExecutionStatus) {
            this.automationExecutionStatus(automationExecutionStatus.toString());
            return this;
        }

        public final void setAutomationExecutionStatus(String automationExecutionStatus) {
            this.automationExecutionStatus = automationExecutionStatus;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        public final String getExecutedBy() {
            return this.executedBy;
        }

        @Override
        public final Builder executedBy(String executedBy) {
            this.executedBy = executedBy;
            return this;
        }

        public final void setExecutedBy(String executedBy) {
            this.executedBy = executedBy;
        }

        public final String getLogFile() {
            return this.logFile;
        }

        @Override
        public final Builder logFile(String logFile) {
            this.logFile = logFile;
            return this;
        }

        public final void setLogFile(String logFile) {
            this.logFile = logFile;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        public final String getModeAsString() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getParentAutomationExecutionId() {
            return this.parentAutomationExecutionId;
        }

        @Override
        public final Builder parentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
            return this;
        }

        public final void setParentAutomationExecutionId(String parentAutomationExecutionId) {
            this.parentAutomationExecutionId = parentAutomationExecutionId;
        }

        public final String getCurrentStepName() {
            return this.currentStepName;
        }

        @Override
        public final Builder currentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
            return this;
        }

        public final void setCurrentStepName(String currentStepName) {
            this.currentStepName = currentStepName;
        }

        public final String getCurrentAction() {
            return this.currentAction;
        }

        @Override
        public final Builder currentAction(String currentAction) {
            this.currentAction = currentAction;
            return this;
        }

        public final void setCurrentAction(String currentAction) {
            this.currentAction = currentAction;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        public final String getTargetParameterName() {
            return this.targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        public final Collection<Target.Builder> getTargets() {
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            return this.targetMaps;
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>> ... targetMaps) {
            this.targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        public final ResolvedTargets.Builder getResolvedTargets() {
            return this.resolvedTargets != null ? this.resolvedTargets.toBuilder() : null;
        }

        @Override
        public final Builder resolvedTargets(ResolvedTargets resolvedTargets) {
            this.resolvedTargets = resolvedTargets;
            return this;
        }

        public final void setResolvedTargets(ResolvedTargets.BuilderImpl resolvedTargets) {
            this.resolvedTargets = resolvedTargets != null ? resolvedTargets.build() : null;
        }

        public final String getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return this.maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getAutomationTypeAsString() {
            return this.automationType;
        }

        @Override
        public final Builder automationType(String automationType) {
            this.automationType = automationType;
            return this;
        }

        @Override
        public final Builder automationType(AutomationType automationType) {
            this.automationType(automationType.toString());
            return this;
        }

        public final void setAutomationType(String automationType) {
            this.automationType = automationType;
        }

        public AutomationExecutionMetadata build() {
            return new AutomationExecutionMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationExecutionMetadata> {
        public Builder automationExecutionId(String var1);

        public Builder documentName(String var1);

        public Builder documentVersion(String var1);

        public Builder automationExecutionStatus(String var1);

        public Builder automationExecutionStatus(AutomationExecutionStatus var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder executedBy(String var1);

        public Builder logFile(String var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder mode(String var1);

        public Builder mode(ExecutionMode var1);

        public Builder parentAutomationExecutionId(String var1);

        public Builder currentStepName(String var1);

        public Builder currentAction(String var1);

        public Builder failureMessage(String var1);

        public Builder targetParameterName(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> var1);

        public Builder targetMaps(Map<String, ? extends Collection<String>> ... var1);

        public Builder resolvedTargets(ResolvedTargets var1);

        default public Builder resolvedTargets(Consumer<ResolvedTargets.Builder> resolvedTargets) {
            return this.resolvedTargets((ResolvedTargets)((ResolvedTargets.Builder)ResolvedTargets.builder().applyMutation(resolvedTargets)).build());
        }

        public Builder maxConcurrency(String var1);

        public Builder maxErrors(String var1);

        public Builder target(String var1);

        public Builder automationType(String var1);

        public Builder automationType(AutomationType var1);
    }
}

