/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InventoryDeletionSummaryItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InventoryDeletionSummaryItem> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InventoryDeletionSummaryItem.getter(InventoryDeletionSummaryItem::version)).setter(InventoryDeletionSummaryItem.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InventoryDeletionSummaryItem.getter(InventoryDeletionSummaryItem::count)).setter(InventoryDeletionSummaryItem.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<Integer> REMAINING_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InventoryDeletionSummaryItem.getter(InventoryDeletionSummaryItem::remainingCount)).setter(InventoryDeletionSummaryItem.setter(Builder::remainingCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemainingCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, COUNT_FIELD, REMAINING_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String version;
    private final Integer count;
    private final Integer remainingCount;

    private InventoryDeletionSummaryItem(BuilderImpl builder) {
        this.version = builder.version;
        this.count = builder.count;
        this.remainingCount = builder.remainingCount;
    }

    public String version() {
        return this.version;
    }

    public Integer count() {
        return this.count;
    }

    public Integer remainingCount() {
        return this.remainingCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.remainingCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryDeletionSummaryItem)) {
            return false;
        }
        InventoryDeletionSummaryItem other = (InventoryDeletionSummaryItem)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.remainingCount(), other.remainingCount());
    }

    public String toString() {
        return ToString.builder((String)"InventoryDeletionSummaryItem").add("Version", (Object)this.version()).add("Count", (Object)this.count()).add("RemainingCount", (Object)this.remainingCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "RemainingCount": {
                return Optional.ofNullable(clazz.cast(this.remainingCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryDeletionSummaryItem, T> g) {
        return obj -> g.apply((InventoryDeletionSummaryItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private Integer count;
        private Integer remainingCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryDeletionSummaryItem model) {
            this.version(model.version);
            this.count(model.count);
            this.remainingCount(model.remainingCount);
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final Integer getRemainingCount() {
            return this.remainingCount;
        }

        @Override
        public final Builder remainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
            return this;
        }

        public final void setRemainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
        }

        public InventoryDeletionSummaryItem build() {
            return new InventoryDeletionSummaryItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InventoryDeletionSummaryItem> {
        public Builder version(String var1);

        public Builder count(Integer var1);

        public Builder remainingCount(Integer var1);
    }
}

