/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowIdentity;

public class DescribeMaintenanceWindowsPublisher
implements SdkPublisher<DescribeMaintenanceWindowsResponse> {
    private final SsmAsyncClient client;
    private final DescribeMaintenanceWindowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMaintenanceWindowsPublisher(SsmAsyncClient client, DescribeMaintenanceWindowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMaintenanceWindowsPublisher(SsmAsyncClient client, DescribeMaintenanceWindowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMaintenanceWindowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMaintenanceWindowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MaintenanceWindowIdentity> windowIdentities() {
        return this.flatMapIterable(response -> response.windowIdentities());
    }

    private class DescribeMaintenanceWindowsResponseFetcher
    implements AsyncPageFetcher<DescribeMaintenanceWindowsResponse> {
        private DescribeMaintenanceWindowsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMaintenanceWindowsResponse> nextPage(DescribeMaintenanceWindowsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowsPublisher.this.client.describeMaintenanceWindows(DescribeMaintenanceWindowsPublisher.this.firstRequest);
            }
            return DescribeMaintenanceWindowsPublisher.this.client.describeMaintenanceWindows((DescribeMaintenanceWindowsRequest)((Object)DescribeMaintenanceWindowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

