/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemSummary;

public class DescribeOpsItemsPublisher
implements SdkPublisher<DescribeOpsItemsResponse> {
    private final SsmAsyncClient client;
    private final DescribeOpsItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOpsItemsPublisher(SsmAsyncClient client, DescribeOpsItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOpsItemsPublisher(SsmAsyncClient client, DescribeOpsItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOpsItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOpsItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OpsItemSummary> opsItemSummaries() {
        return this.flatMapIterable(response -> response.opsItemSummaries());
    }

    private class DescribeOpsItemsResponseFetcher
    implements AsyncPageFetcher<DescribeOpsItemsResponse> {
        private DescribeOpsItemsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOpsItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeOpsItemsResponse> nextPage(DescribeOpsItemsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOpsItemsPublisher.this.client.describeOpsItems(DescribeOpsItemsPublisher.this.firstRequest);
            }
            return DescribeOpsItemsPublisher.this.client.describeOpsItems((DescribeOpsItemsRequest)((Object)DescribeOpsItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

