/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowTask;

public class DescribeMaintenanceWindowTasksPublisher
implements SdkPublisher<DescribeMaintenanceWindowTasksResponse> {
    private final SsmAsyncClient client;
    private final DescribeMaintenanceWindowTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeMaintenanceWindowTasksPublisher(SsmAsyncClient client, DescribeMaintenanceWindowTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeMaintenanceWindowTasksPublisher(SsmAsyncClient client, DescribeMaintenanceWindowTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeMaintenanceWindowTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeMaintenanceWindowTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MaintenanceWindowTask> tasks() {
        return this.flatMapIterable(response -> response.tasks());
    }

    private class DescribeMaintenanceWindowTasksResponseFetcher
    implements AsyncPageFetcher<DescribeMaintenanceWindowTasksResponse> {
        private DescribeMaintenanceWindowTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMaintenanceWindowTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeMaintenanceWindowTasksResponse> nextPage(DescribeMaintenanceWindowTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeMaintenanceWindowTasksPublisher.this.client.describeMaintenanceWindowTasks(DescribeMaintenanceWindowTasksPublisher.this.firstRequest);
            }
            return DescribeMaintenanceWindowTasksPublisher.this.client.describeMaintenanceWindowTasks((DescribeMaintenanceWindowTasksRequest)((Object)DescribeMaintenanceWindowTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

