/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PingStatus {
    ONLINE("Online"),
    CONNECTION_LOST("ConnectionLost"),
    INACTIVE("Inactive"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PingStatus> VALUE_MAP;
    private final String value;

    private PingStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PingStatus> knownValues() {
        EnumSet<PingStatus> knownValues = EnumSet.allOf(PingStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PingStatus.class, PingStatus::toString);
    }
}

