/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmAsyncClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.ListNodesSummaryRequest;
import software.amazon.awssdk.services.ssm.model.ListNodesSummaryResponse;

public class ListNodesSummaryPublisher
implements SdkPublisher<ListNodesSummaryResponse> {
    private final SsmAsyncClient client;
    private final ListNodesSummaryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNodesSummaryPublisher(SsmAsyncClient client, ListNodesSummaryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNodesSummaryPublisher(SsmAsyncClient client, ListNodesSummaryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNodesSummaryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNodesSummaryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Map<String, String>> summary() {
        Function<ListNodesSummaryResponse, Iterator> getIterator = response -> {
            if (response != null && response.summary() != null) {
                return response.summary().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListNodesSummaryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListNodesSummaryResponseFetcher
    implements AsyncPageFetcher<ListNodesSummaryResponse> {
        private ListNodesSummaryResponseFetcher() {
        }

        public boolean hasNextPage(ListNodesSummaryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListNodesSummaryResponse> nextPage(ListNodesSummaryResponse previousPage) {
            if (previousPage == null) {
                return ListNodesSummaryPublisher.this.client.listNodesSummary(ListNodesSummaryPublisher.this.firstRequest);
            }
            return ListNodesSummaryPublisher.this.client.listNodesSummary((ListNodesSummaryRequest)((Object)ListNodesSummaryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

