/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.InventoryItem;
import software.amazon.awssdk.services.ssm.model.InventoryItemListCopier;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInventoryRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, PutInventoryRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(PutInventoryRequest.getter(PutInventoryRequest::instanceId)).setter(PutInventoryRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<List<InventoryItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(PutInventoryRequest.getter(PutInventoryRequest::items)).setter(PutInventoryRequest.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InventoryItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutInventoryRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final List<InventoryItem> items;

    private PutInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.items = builder.items;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<InventoryItem> items() {
        return this.items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInventoryRequest)) {
            return false;
        }
        PutInventoryRequest other = (PutInventoryRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items());
    }

    public final String toString() {
        return ToString.builder((String)"PutInventoryRequest").add("InstanceId", (Object)this.instanceId()).add("Items", this.hasItems() ? this.items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Items", ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutInventoryRequest, T> g) {
        return obj -> g.apply((PutInventoryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private List<InventoryItem> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutInventoryRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.items(model.items);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final List<InventoryItem.Builder> getItems() {
            List<InventoryItem.Builder> result = InventoryItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<InventoryItem.BuilderImpl> items) {
            this.items = InventoryItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<InventoryItem> items) {
            this.items = InventoryItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(InventoryItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<InventoryItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (InventoryItem)((InventoryItem.Builder)InventoryItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutInventoryRequest build() {
            return new PutInventoryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutInventoryRequest> {
        public Builder instanceId(String var1);

        public Builder items(Collection<InventoryItem> var1);

        public Builder items(InventoryItem ... var1);

        public Builder items(Consumer<InventoryItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

