/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.ImpactType;
import software.amazon.awssdk.services.ssm.model.RegionListCopier;
import software.amazon.awssdk.services.ssm.model.StepPreviewMapCopier;
import software.amazon.awssdk.services.ssm.model.TargetPreview;
import software.amazon.awssdk.services.ssm.model.TargetPreviewListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomationExecutionPreview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomationExecutionPreview> {
    private static final SdkField<Map<String, Integer>> STEP_PREVIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StepPreviews").getter(AutomationExecutionPreview.getter(AutomationExecutionPreview::stepPreviewsAsStrings)).setter(AutomationExecutionPreview.setter(Builder::stepPreviewsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepPreviews").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(AutomationExecutionPreview.getter(AutomationExecutionPreview::regions)).setter(AutomationExecutionPreview.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TargetPreview>> TARGET_PREVIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetPreviews").getter(AutomationExecutionPreview.getter(AutomationExecutionPreview::targetPreviews)).setter(AutomationExecutionPreview.setter(Builder::targetPreviews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPreviews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetPreview::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalAccounts").getter(AutomationExecutionPreview.getter(AutomationExecutionPreview::totalAccounts)).setter(AutomationExecutionPreview.setter(Builder::totalAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalAccounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_PREVIEWS_FIELD, REGIONS_FIELD, TARGET_PREVIEWS_FIELD, TOTAL_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomationExecutionPreview.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, Integer> stepPreviews;
    private final List<String> regions;
    private final List<TargetPreview> targetPreviews;
    private final Integer totalAccounts;

    private AutomationExecutionPreview(BuilderImpl builder) {
        this.stepPreviews = builder.stepPreviews;
        this.regions = builder.regions;
        this.targetPreviews = builder.targetPreviews;
        this.totalAccounts = builder.totalAccounts;
    }

    public final Map<ImpactType, Integer> stepPreviews() {
        return StepPreviewMapCopier.copyStringToEnum(this.stepPreviews);
    }

    public final boolean hasStepPreviews() {
        return this.stepPreviews != null && !(this.stepPreviews instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> stepPreviewsAsStrings() {
        return this.stepPreviews;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final boolean hasTargetPreviews() {
        return this.targetPreviews != null && !(this.targetPreviews instanceof SdkAutoConstructList);
    }

    public final List<TargetPreview> targetPreviews() {
        return this.targetPreviews;
    }

    public final Integer totalAccounts() {
        return this.totalAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStepPreviews() ? this.stepPreviewsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetPreviews() ? this.targetPreviews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalAccounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationExecutionPreview)) {
            return false;
        }
        AutomationExecutionPreview other = (AutomationExecutionPreview)obj;
        return this.hasStepPreviews() == other.hasStepPreviews() && Objects.equals(this.stepPreviewsAsStrings(), other.stepPreviewsAsStrings()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && this.hasTargetPreviews() == other.hasTargetPreviews() && Objects.equals(this.targetPreviews(), other.targetPreviews()) && Objects.equals(this.totalAccounts(), other.totalAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"AutomationExecutionPreview").add("StepPreviews", this.hasStepPreviews() ? this.stepPreviewsAsStrings() : null).add("Regions", this.hasRegions() ? this.regions() : null).add("TargetPreviews", this.hasTargetPreviews() ? this.targetPreviews() : null).add("TotalAccounts", (Object)this.totalAccounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepPreviews": {
                return Optional.ofNullable(clazz.cast(this.stepPreviewsAsStrings()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "TargetPreviews": {
                return Optional.ofNullable(clazz.cast(this.targetPreviews()));
            }
            case "TotalAccounts": {
                return Optional.ofNullable(clazz.cast(this.totalAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StepPreviews", STEP_PREVIEWS_FIELD);
        map.put("Regions", REGIONS_FIELD);
        map.put("TargetPreviews", TARGET_PREVIEWS_FIELD);
        map.put("TotalAccounts", TOTAL_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationExecutionPreview, T> g) {
        return obj -> g.apply((AutomationExecutionPreview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Integer> stepPreviews = DefaultSdkAutoConstructMap.getInstance();
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private List<TargetPreview> targetPreviews = DefaultSdkAutoConstructList.getInstance();
        private Integer totalAccounts;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationExecutionPreview model) {
            this.stepPreviewsWithStrings(model.stepPreviews);
            this.regions(model.regions);
            this.targetPreviews(model.targetPreviews);
            this.totalAccounts(model.totalAccounts);
        }

        public final Map<String, Integer> getStepPreviews() {
            if (this.stepPreviews instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.stepPreviews;
        }

        public final void setStepPreviews(Map<String, Integer> stepPreviews) {
            this.stepPreviews = StepPreviewMapCopier.copy(stepPreviews);
        }

        @Override
        public final Builder stepPreviewsWithStrings(Map<String, Integer> stepPreviews) {
            this.stepPreviews = StepPreviewMapCopier.copy(stepPreviews);
            return this;
        }

        @Override
        public final Builder stepPreviews(Map<ImpactType, Integer> stepPreviews) {
            this.stepPreviews = StepPreviewMapCopier.copyEnumToString(stepPreviews);
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final List<TargetPreview.Builder> getTargetPreviews() {
            List<TargetPreview.Builder> result = TargetPreviewListCopier.copyToBuilder(this.targetPreviews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetPreviews(Collection<TargetPreview.BuilderImpl> targetPreviews) {
            this.targetPreviews = TargetPreviewListCopier.copyFromBuilder(targetPreviews);
        }

        @Override
        public final Builder targetPreviews(Collection<TargetPreview> targetPreviews) {
            this.targetPreviews = TargetPreviewListCopier.copy(targetPreviews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetPreviews(TargetPreview ... targetPreviews) {
            this.targetPreviews(Arrays.asList(targetPreviews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetPreviews(Consumer<TargetPreview.Builder> ... targetPreviews) {
            this.targetPreviews(Stream.of(targetPreviews).map(c -> (TargetPreview)((TargetPreview.Builder)TargetPreview.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalAccounts() {
            return this.totalAccounts;
        }

        public final void setTotalAccounts(Integer totalAccounts) {
            this.totalAccounts = totalAccounts;
        }

        @Override
        public final Builder totalAccounts(Integer totalAccounts) {
            this.totalAccounts = totalAccounts;
            return this;
        }

        public AutomationExecutionPreview build() {
            return new AutomationExecutionPreview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomationExecutionPreview> {
        public Builder stepPreviewsWithStrings(Map<String, Integer> var1);

        public Builder stepPreviews(Map<ImpactType, Integer> var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder targetPreviews(Collection<TargetPreview> var1);

        public Builder targetPreviews(TargetPreview ... var1);

        public Builder targetPreviews(Consumer<TargetPreview.Builder> ... var1);

        public Builder totalAccounts(Integer var1);
    }
}

