/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.SignalType;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendAutomationSignalRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, SendAutomationSignalRequest> {
    private static final SdkField<String> AUTOMATION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationExecutionId").getter(SendAutomationSignalRequest.getter(SendAutomationSignalRequest::automationExecutionId)).setter(SendAutomationSignalRequest.setter(Builder::automationExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecutionId").build()}).build();
    private static final SdkField<String> SIGNAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignalType").getter(SendAutomationSignalRequest.getter(SendAutomationSignalRequest::signalTypeAsString)).setter(SendAutomationSignalRequest.setter(Builder::signalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalType").build()}).build();
    private static final SdkField<Map<String, List<String>>> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Payload").getter(SendAutomationSignalRequest.getter(SendAutomationSignalRequest::payload)).setter(SendAutomationSignalRequest.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_ID_FIELD, SIGNAL_TYPE_FIELD, PAYLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SendAutomationSignalRequest.memberNameToFieldInitializer();
    private final String automationExecutionId;
    private final String signalType;
    private final Map<String, List<String>> payload;

    private SendAutomationSignalRequest(BuilderImpl builder) {
        super(builder);
        this.automationExecutionId = builder.automationExecutionId;
        this.signalType = builder.signalType;
        this.payload = builder.payload;
    }

    public final String automationExecutionId() {
        return this.automationExecutionId;
    }

    public final SignalType signalType() {
        return SignalType.fromValue(this.signalType);
    }

    public final String signalTypeAsString() {
        return this.signalType;
    }

    public final boolean hasPayload() {
        return this.payload != null && !(this.payload instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> payload() {
        return this.payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.automationExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPayload() ? this.payload() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendAutomationSignalRequest)) {
            return false;
        }
        SendAutomationSignalRequest other = (SendAutomationSignalRequest)((Object)obj);
        return Objects.equals(this.automationExecutionId(), other.automationExecutionId()) && Objects.equals(this.signalTypeAsString(), other.signalTypeAsString()) && this.hasPayload() == other.hasPayload() && Objects.equals(this.payload(), other.payload());
    }

    public final String toString() {
        return ToString.builder((String)"SendAutomationSignalRequest").add("AutomationExecutionId", (Object)this.automationExecutionId()).add("SignalType", (Object)this.signalTypeAsString()).add("Payload", this.hasPayload() ? this.payload() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutomationExecutionId": {
                return Optional.ofNullable(clazz.cast(this.automationExecutionId()));
            }
            case "SignalType": {
                return Optional.ofNullable(clazz.cast(this.signalTypeAsString()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutomationExecutionId", AUTOMATION_EXECUTION_ID_FIELD);
        map.put("SignalType", SIGNAL_TYPE_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendAutomationSignalRequest, T> g) {
        return obj -> g.apply((SendAutomationSignalRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String automationExecutionId;
        private String signalType;
        private Map<String, List<String>> payload = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendAutomationSignalRequest model) {
            super(model);
            this.automationExecutionId(model.automationExecutionId);
            this.signalType(model.signalType);
            this.payload(model.payload);
        }

        public final String getAutomationExecutionId() {
            return this.automationExecutionId;
        }

        public final void setAutomationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
        }

        @Override
        public final Builder automationExecutionId(String automationExecutionId) {
            this.automationExecutionId = automationExecutionId;
            return this;
        }

        public final String getSignalType() {
            return this.signalType;
        }

        public final void setSignalType(String signalType) {
            this.signalType = signalType;
        }

        @Override
        public final Builder signalType(String signalType) {
            this.signalType = signalType;
            return this;
        }

        @Override
        public final Builder signalType(SignalType signalType) {
            this.signalType(signalType == null ? null : signalType.toString());
            return this;
        }

        public final Map<String, ? extends Collection<String>> getPayload() {
            if (this.payload instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.payload;
        }

        public final void setPayload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
        }

        @Override
        public final Builder payload(Map<String, ? extends Collection<String>> payload) {
            this.payload = AutomationParameterMapCopier.copy(payload);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendAutomationSignalRequest build() {
            return new SendAutomationSignalRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendAutomationSignalRequest> {
        public Builder automationExecutionId(String var1);

        public Builder signalType(String var1);

        public Builder signalType(SignalType var1);

        public Builder payload(Map<String, ? extends Collection<String>> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

