/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.OperatingSystem;
import software.amazon.awssdk.services.ssm.model.PatchAction;
import software.amazon.awssdk.services.ssm.model.PatchComplianceLevel;
import software.amazon.awssdk.services.ssm.model.PatchComplianceStatus;
import software.amazon.awssdk.services.ssm.model.PatchFilterGroup;
import software.amazon.awssdk.services.ssm.model.PatchIdListCopier;
import software.amazon.awssdk.services.ssm.model.PatchRuleGroup;
import software.amazon.awssdk.services.ssm.model.PatchSource;
import software.amazon.awssdk.services.ssm.model.PatchSourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BaselineOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BaselineOverride> {
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperatingSystem").getter(BaselineOverride.getter(BaselineOverride::operatingSystemAsString)).setter(BaselineOverride.setter(Builder::operatingSystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<PatchFilterGroup> GLOBAL_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GlobalFilters").getter(BaselineOverride.getter(BaselineOverride::globalFilters)).setter(BaselineOverride.setter(Builder::globalFilters)).constructor(PatchFilterGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalFilters").build()}).build();
    private static final SdkField<PatchRuleGroup> APPROVAL_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApprovalRules").getter(BaselineOverride.getter(BaselineOverride::approvalRules)).setter(BaselineOverride.setter(Builder::approvalRules)).constructor(PatchRuleGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalRules").build()}).build();
    private static final SdkField<List<String>> APPROVED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApprovedPatches").getter(BaselineOverride.getter(BaselineOverride::approvedPatches)).setter(BaselineOverride.setter(Builder::approvedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApprovedPatchesComplianceLevel").getter(BaselineOverride.getter(BaselineOverride::approvedPatchesComplianceLevelAsString)).setter(BaselineOverride.setter(Builder::approvedPatchesComplianceLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesComplianceLevel").build()}).build();
    private static final SdkField<List<String>> REJECTED_PATCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RejectedPatches").getter(BaselineOverride.getter(BaselineOverride::rejectedPatches)).setter(BaselineOverride.setter(Builder::rejectedPatches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatches").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REJECTED_PATCHES_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RejectedPatchesAction").getter(BaselineOverride.getter(BaselineOverride::rejectedPatchesActionAsString)).setter(BaselineOverride.setter(Builder::rejectedPatchesAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatchesAction").build()}).build();
    private static final SdkField<Boolean> APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApprovedPatchesEnableNonSecurity").getter(BaselineOverride.getter(BaselineOverride::approvedPatchesEnableNonSecurity)).setter(BaselineOverride.setter(Builder::approvedPatchesEnableNonSecurity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesEnableNonSecurity").build()}).build();
    private static final SdkField<List<PatchSource>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sources").getter(BaselineOverride.getter(BaselineOverride::sources)).setter(BaselineOverride.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABLE_SECURITY_UPDATES_COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailableSecurityUpdatesComplianceStatus").getter(BaselineOverride.getter(BaselineOverride::availableSecurityUpdatesComplianceStatusAsString)).setter(BaselineOverride.setter(Builder::availableSecurityUpdatesComplianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableSecurityUpdatesComplianceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATING_SYSTEM_FIELD, GLOBAL_FILTERS_FIELD, APPROVAL_RULES_FIELD, APPROVED_PATCHES_FIELD, APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD, REJECTED_PATCHES_FIELD, REJECTED_PATCHES_ACTION_FIELD, APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD, SOURCES_FIELD, AVAILABLE_SECURITY_UPDATES_COMPLIANCE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BaselineOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operatingSystem;
    private final PatchFilterGroup globalFilters;
    private final PatchRuleGroup approvalRules;
    private final List<String> approvedPatches;
    private final String approvedPatchesComplianceLevel;
    private final List<String> rejectedPatches;
    private final String rejectedPatchesAction;
    private final Boolean approvedPatchesEnableNonSecurity;
    private final List<PatchSource> sources;
    private final String availableSecurityUpdatesComplianceStatus;

    private BaselineOverride(BuilderImpl builder) {
        this.operatingSystem = builder.operatingSystem;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.rejectedPatches = builder.rejectedPatches;
        this.rejectedPatchesAction = builder.rejectedPatchesAction;
        this.approvedPatchesEnableNonSecurity = builder.approvedPatchesEnableNonSecurity;
        this.sources = builder.sources;
        this.availableSecurityUpdatesComplianceStatus = builder.availableSecurityUpdatesComplianceStatus;
    }

    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(this.operatingSystem);
    }

    public final String operatingSystemAsString() {
        return this.operatingSystem;
    }

    public final PatchFilterGroup globalFilters() {
        return this.globalFilters;
    }

    public final PatchRuleGroup approvalRules() {
        return this.approvalRules;
    }

    public final boolean hasApprovedPatches() {
        return this.approvedPatches != null && !(this.approvedPatches instanceof SdkAutoConstructList);
    }

    public final List<String> approvedPatches() {
        return this.approvedPatches;
    }

    public final PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(this.approvedPatchesComplianceLevel);
    }

    public final String approvedPatchesComplianceLevelAsString() {
        return this.approvedPatchesComplianceLevel;
    }

    public final boolean hasRejectedPatches() {
        return this.rejectedPatches != null && !(this.rejectedPatches instanceof SdkAutoConstructList);
    }

    public final List<String> rejectedPatches() {
        return this.rejectedPatches;
    }

    public final PatchAction rejectedPatchesAction() {
        return PatchAction.fromValue(this.rejectedPatchesAction);
    }

    public final String rejectedPatchesActionAsString() {
        return this.rejectedPatchesAction;
    }

    public final Boolean approvedPatchesEnableNonSecurity() {
        return this.approvedPatchesEnableNonSecurity;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<PatchSource> sources() {
        return this.sources;
    }

    public final PatchComplianceStatus availableSecurityUpdatesComplianceStatus() {
        return PatchComplianceStatus.fromValue(this.availableSecurityUpdatesComplianceStatus);
    }

    public final String availableSecurityUpdatesComplianceStatusAsString() {
        return this.availableSecurityUpdatesComplianceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovedPatches() ? this.approvedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatchesComplianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRejectedPatches() ? this.rejectedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectedPatchesActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvedPatchesEnableNonSecurity());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availableSecurityUpdatesComplianceStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaselineOverride)) {
            return false;
        }
        BaselineOverride other = (BaselineOverride)obj;
        return Objects.equals(this.operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(this.globalFilters(), other.globalFilters()) && Objects.equals(this.approvalRules(), other.approvalRules()) && this.hasApprovedPatches() == other.hasApprovedPatches() && Objects.equals(this.approvedPatches(), other.approvedPatches()) && Objects.equals(this.approvedPatchesComplianceLevelAsString(), other.approvedPatchesComplianceLevelAsString()) && this.hasRejectedPatches() == other.hasRejectedPatches() && Objects.equals(this.rejectedPatches(), other.rejectedPatches()) && Objects.equals(this.rejectedPatchesActionAsString(), other.rejectedPatchesActionAsString()) && Objects.equals(this.approvedPatchesEnableNonSecurity(), other.approvedPatchesEnableNonSecurity()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.availableSecurityUpdatesComplianceStatusAsString(), other.availableSecurityUpdatesComplianceStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BaselineOverride").add("OperatingSystem", (Object)this.operatingSystemAsString()).add("GlobalFilters", (Object)this.globalFilters()).add("ApprovalRules", (Object)this.approvalRules()).add("ApprovedPatches", this.hasApprovedPatches() ? this.approvedPatches() : null).add("ApprovedPatchesComplianceLevel", (Object)this.approvedPatchesComplianceLevelAsString()).add("RejectedPatches", this.hasRejectedPatches() ? this.rejectedPatches() : null).add("RejectedPatchesAction", (Object)this.rejectedPatchesActionAsString()).add("ApprovedPatchesEnableNonSecurity", (Object)this.approvedPatchesEnableNonSecurity()).add("Sources", this.hasSources() ? this.sources() : null).add("AvailableSecurityUpdatesComplianceStatus", (Object)this.availableSecurityUpdatesComplianceStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystemAsString()));
            }
            case "GlobalFilters": {
                return Optional.ofNullable(clazz.cast(this.globalFilters()));
            }
            case "ApprovalRules": {
                return Optional.ofNullable(clazz.cast(this.approvalRules()));
            }
            case "ApprovedPatches": {
                return Optional.ofNullable(clazz.cast(this.approvedPatches()));
            }
            case "ApprovedPatchesComplianceLevel": {
                return Optional.ofNullable(clazz.cast(this.approvedPatchesComplianceLevelAsString()));
            }
            case "RejectedPatches": {
                return Optional.ofNullable(clazz.cast(this.rejectedPatches()));
            }
            case "RejectedPatchesAction": {
                return Optional.ofNullable(clazz.cast(this.rejectedPatchesActionAsString()));
            }
            case "ApprovedPatchesEnableNonSecurity": {
                return Optional.ofNullable(clazz.cast(this.approvedPatchesEnableNonSecurity()));
            }
            case "Sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "AvailableSecurityUpdatesComplianceStatus": {
                return Optional.ofNullable(clazz.cast(this.availableSecurityUpdatesComplianceStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
        map.put("GlobalFilters", GLOBAL_FILTERS_FIELD);
        map.put("ApprovalRules", APPROVAL_RULES_FIELD);
        map.put("ApprovedPatches", APPROVED_PATCHES_FIELD);
        map.put("ApprovedPatchesComplianceLevel", APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD);
        map.put("RejectedPatches", REJECTED_PATCHES_FIELD);
        map.put("RejectedPatchesAction", REJECTED_PATCHES_ACTION_FIELD);
        map.put("ApprovedPatchesEnableNonSecurity", APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD);
        map.put("Sources", SOURCES_FIELD);
        map.put("AvailableSecurityUpdatesComplianceStatus", AVAILABLE_SECURITY_UPDATES_COMPLIANCE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BaselineOverride, T> g) {
        return obj -> g.apply((BaselineOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operatingSystem;
        private PatchFilterGroup globalFilters;
        private PatchRuleGroup approvalRules;
        private List<String> approvedPatches = DefaultSdkAutoConstructList.getInstance();
        private String approvedPatchesComplianceLevel;
        private List<String> rejectedPatches = DefaultSdkAutoConstructList.getInstance();
        private String rejectedPatchesAction;
        private Boolean approvedPatchesEnableNonSecurity;
        private List<PatchSource> sources = DefaultSdkAutoConstructList.getInstance();
        private String availableSecurityUpdatesComplianceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BaselineOverride model) {
            this.operatingSystem(model.operatingSystem);
            this.globalFilters(model.globalFilters);
            this.approvalRules(model.approvalRules);
            this.approvedPatches(model.approvedPatches);
            this.approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            this.rejectedPatches(model.rejectedPatches);
            this.rejectedPatchesAction(model.rejectedPatchesAction);
            this.approvedPatchesEnableNonSecurity(model.approvedPatchesEnableNonSecurity);
            this.sources(model.sources);
            this.availableSecurityUpdatesComplianceStatus(model.availableSecurityUpdatesComplianceStatus);
        }

        public final String getOperatingSystem() {
            return this.operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return this.globalFilters != null ? this.globalFilters.toBuilder() : null;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return this.approvalRules != null ? this.approvalRules.toBuilder() : null;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final Collection<String> getApprovedPatches() {
            if (this.approvedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.approvedPatches;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String ... approvedPatches) {
            this.approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final String getApprovedPatchesComplianceLevel() {
            return this.approvedPatchesComplianceLevel;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel == null ? null : approvedPatchesComplianceLevel.toString());
            return this;
        }

        public final Collection<String> getRejectedPatches() {
            if (this.rejectedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rejectedPatches;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String ... rejectedPatches) {
            this.rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final String getRejectedPatchesAction() {
            return this.rejectedPatchesAction;
        }

        public final void setRejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
        }

        @Override
        public final Builder rejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
            return this;
        }

        @Override
        public final Builder rejectedPatchesAction(PatchAction rejectedPatchesAction) {
            this.rejectedPatchesAction(rejectedPatchesAction == null ? null : rejectedPatchesAction.toString());
            return this;
        }

        public final Boolean getApprovedPatchesEnableNonSecurity() {
            return this.approvedPatchesEnableNonSecurity;
        }

        public final void setApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
        }

        @Override
        public final Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
            return this;
        }

        public final List<PatchSource.Builder> getSources() {
            List<PatchSource.Builder> result = PatchSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<PatchSource.BuilderImpl> sources) {
            this.sources = PatchSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<PatchSource> sources) {
            this.sources = PatchSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(PatchSource ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<PatchSource.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (PatchSource)((PatchSource.Builder)PatchSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailableSecurityUpdatesComplianceStatus() {
            return this.availableSecurityUpdatesComplianceStatus;
        }

        public final void setAvailableSecurityUpdatesComplianceStatus(String availableSecurityUpdatesComplianceStatus) {
            this.availableSecurityUpdatesComplianceStatus = availableSecurityUpdatesComplianceStatus;
        }

        @Override
        public final Builder availableSecurityUpdatesComplianceStatus(String availableSecurityUpdatesComplianceStatus) {
            this.availableSecurityUpdatesComplianceStatus = availableSecurityUpdatesComplianceStatus;
            return this;
        }

        @Override
        public final Builder availableSecurityUpdatesComplianceStatus(PatchComplianceStatus availableSecurityUpdatesComplianceStatus) {
            this.availableSecurityUpdatesComplianceStatus(availableSecurityUpdatesComplianceStatus == null ? null : availableSecurityUpdatesComplianceStatus.toString());
            return this;
        }

        public BaselineOverride build() {
            return new BaselineOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BaselineOverride> {
        public Builder operatingSystem(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        public Builder globalFilters(PatchFilterGroup var1);

        default public Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return this.globalFilters((PatchFilterGroup)((PatchFilterGroup.Builder)PatchFilterGroup.builder().applyMutation(globalFilters)).build());
        }

        public Builder approvalRules(PatchRuleGroup var1);

        default public Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return this.approvalRules((PatchRuleGroup)((PatchRuleGroup.Builder)PatchRuleGroup.builder().applyMutation(approvalRules)).build());
        }

        public Builder approvedPatches(Collection<String> var1);

        public Builder approvedPatches(String ... var1);

        public Builder approvedPatchesComplianceLevel(String var1);

        public Builder approvedPatchesComplianceLevel(PatchComplianceLevel var1);

        public Builder rejectedPatches(Collection<String> var1);

        public Builder rejectedPatches(String ... var1);

        public Builder rejectedPatchesAction(String var1);

        public Builder rejectedPatchesAction(PatchAction var1);

        public Builder approvedPatchesEnableNonSecurity(Boolean var1);

        public Builder sources(Collection<PatchSource> var1);

        public Builder sources(PatchSource ... var1);

        public Builder sources(Consumer<PatchSource.Builder> ... var1);

        public Builder availableSecurityUpdatesComplianceStatus(String var1);

        public Builder availableSecurityUpdatesComplianceStatus(PatchComplianceStatus var1);
    }
}

