/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A detailed status of the parent step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParentStepDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ParentStepDetails.Builder, ParentStepDetails> {
    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepExecutionId").getter(getter(ParentStepDetails::stepExecutionId))
            .setter(setter(Builder::stepExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutionId").build()).build();

    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StepName").getter(getter(ParentStepDetails::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepName").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(ParentStepDetails::action)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Integer> ITERATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Iteration").getter(getter(ParentStepDetails::iteration)).setter(setter(Builder::iteration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iteration").build()).build();

    private static final SdkField<String> ITERATOR_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IteratorValue").getter(getter(ParentStepDetails::iteratorValue)).setter(setter(Builder::iteratorValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IteratorValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_EXECUTION_ID_FIELD,
            STEP_NAME_FIELD, ACTION_FIELD, ITERATION_FIELD, ITERATOR_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stepExecutionId;

    private final String stepName;

    private final String action;

    private final Integer iteration;

    private final String iteratorValue;

    private ParentStepDetails(BuilderImpl builder) {
        this.stepExecutionId = builder.stepExecutionId;
        this.stepName = builder.stepName;
        this.action = builder.action;
        this.iteration = builder.iteration;
        this.iteratorValue = builder.iteratorValue;
    }

    /**
     * <p>
     * The unique ID of a step execution.
     * </p>
     * 
     * @return The unique ID of a step execution.
     */
    public final String stepExecutionId() {
        return stepExecutionId;
    }

    /**
     * <p>
     * The name of the step.
     * </p>
     * 
     * @return The name of the step.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The name of the automation action.
     * </p>
     * 
     * @return The name of the automation action.
     */
    public final String action() {
        return action;
    }

    /**
     * <p>
     * The current repetition of the loop represented by an integer.
     * </p>
     * 
     * @return The current repetition of the loop represented by an integer.
     */
    public final Integer iteration() {
        return iteration;
    }

    /**
     * <p>
     * The current value of the specified iterator in the loop.
     * </p>
     * 
     * @return The current value of the specified iterator in the loop.
     */
    public final String iteratorValue() {
        return iteratorValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(iteration());
        hashCode = 31 * hashCode + Objects.hashCode(iteratorValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentStepDetails)) {
            return false;
        }
        ParentStepDetails other = (ParentStepDetails) obj;
        return Objects.equals(stepExecutionId(), other.stepExecutionId()) && Objects.equals(stepName(), other.stepName())
                && Objects.equals(action(), other.action()) && Objects.equals(iteration(), other.iteration())
                && Objects.equals(iteratorValue(), other.iteratorValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParentStepDetails").add("StepExecutionId", stepExecutionId()).add("StepName", stepName())
                .add("Action", action()).add("Iteration", iteration()).add("IteratorValue", iteratorValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StepExecutionId":
            return Optional.ofNullable(clazz.cast(stepExecutionId()));
        case "StepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Iteration":
            return Optional.ofNullable(clazz.cast(iteration()));
        case "IteratorValue":
            return Optional.ofNullable(clazz.cast(iteratorValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StepExecutionId", STEP_EXECUTION_ID_FIELD);
        map.put("StepName", STEP_NAME_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Iteration", ITERATION_FIELD);
        map.put("IteratorValue", ITERATOR_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParentStepDetails, T> g) {
        return obj -> g.apply((ParentStepDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParentStepDetails> {
        /**
         * <p>
         * The unique ID of a step execution.
         * </p>
         * 
         * @param stepExecutionId
         *        The unique ID of a step execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepExecutionId(String stepExecutionId);

        /**
         * <p>
         * The name of the step.
         * </p>
         * 
         * @param stepName
         *        The name of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The name of the automation action.
         * </p>
         * 
         * @param action
         *        The name of the automation action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String action);

        /**
         * <p>
         * The current repetition of the loop represented by an integer.
         * </p>
         * 
         * @param iteration
         *        The current repetition of the loop represented by an integer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iteration(Integer iteration);

        /**
         * <p>
         * The current value of the specified iterator in the loop.
         * </p>
         * 
         * @param iteratorValue
         *        The current value of the specified iterator in the loop.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iteratorValue(String iteratorValue);
    }

    static final class BuilderImpl implements Builder {
        private String stepExecutionId;

        private String stepName;

        private String action;

        private Integer iteration;

        private String iteratorValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ParentStepDetails model) {
            stepExecutionId(model.stepExecutionId);
            stepName(model.stepName);
            action(model.action);
            iteration(model.iteration);
            iteratorValue(model.iteratorValue);
        }

        public final String getStepExecutionId() {
            return stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final Integer getIteration() {
            return iteration;
        }

        public final void setIteration(Integer iteration) {
            this.iteration = iteration;
        }

        @Override
        public final Builder iteration(Integer iteration) {
            this.iteration = iteration;
            return this;
        }

        public final String getIteratorValue() {
            return iteratorValue;
        }

        public final void setIteratorValue(String iteratorValue) {
            this.iteratorValue = iteratorValue;
        }

        @Override
        public final Builder iteratorValue(String iteratorValue) {
            this.iteratorValue = iteratorValue;
            return this;
        }

        @Override
        public ParentStepDetails build() {
            return new ParentStepDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
